package kinetic;
import java.awt.*;
import java.lang.*;

/** 
 * This class produces a uniform change onto any attached property.
 *
 * It applies an offset to the incomming property value.  The offset is 0 when t<=0, and offset=amount when t>= duration.
 */
public class Change extends Behavior{

    /** property storing the desired offset this behavior produces
     *
     */    
	protected KineticProperty amount = new KineticProperty(10);

        /** constructs a new instance of the Change behavior with default parameters
         */        
	public Change() {
		properties.add(amount);
	}

        /** creates a new instance of the Change behavior using the parameters
         * @param delay_val time delay before starting - milliseconds
         *
         * @param dur_val lifespan of the before, time needed to complete - milliseconds
         * @param amount_val amount of offset
         *
         */        
	public Change(double delay_val, double dur_val, double amount_val)
		{
		this();
		amount.setValue(amount_val);
		duration.setValue(dur_val);
		addTimeFilter(new Delay(delay_val));
		}

        /** sets the amount of offset
         * @param new_amount new offset
         */        
	public void setAmount(double new_amount) {
		amount.setValue(new_amount);
	}
	
        /** main routine that produces that effect
         */        
	public void Process() {
            if(owner != null) {
                if(current_time <= 0) //causal function
                        return;
                if(current_time < duration.endValue) {
                        owner.endValue += (current_time/duration.endValue)*amount.endValue;
                        isDone = false;
                        }
                else {
                        owner.endValue += amount.endValue;
                        isDone = true;
                        }
            }
	}
}
