package kinetic;
import java.awt.*;
import java.lang.*;
/** 
 * time filter that reverses the flow of time over a given duration.  For exmaple, if the duration is set to 10 seconds for the first 10 seconds, the time will count down from 10 to 0.  After the lifspan is over it will resume at 10 seconds.
 */
public class Reverse extends TimeFilter{
        /** creates new instance of reverse with a duration
         *@param dur window of time to count backwords
         */
	public Reverse(double dur) {
		duration.setValue(dur);
	}
        /** processed input value of time to produce an new output value of time
         *@param time input value of time
         *@return processed output value of time
         */
	public double apply(double time) {
		PrepareVariables(time);//process properties first.
		if((time < 0)||(time > duration.getEndValue()))
			return time;
		return (duration.getEndValue() - time);
	}
}
