package KTEditor; 

import javax.swing.text.*;
import java.util.Vector;
import java.util.Enumeration;

/** 
 * xx
 */
public class EffectSegment {
        
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    /* Instance variables */
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */   
    
    /** The document that this segment comes out of */
    protected StyledDocument document = null;
    
    /** Get the document that this segment comes out of */
    public StyledDocument getDocument() {return document;}
    
    /** Set the document that this segment comes out of */
    public void setDocument(StyledDocument doc) {document = doc;}
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /** 
     * The offset in the document corresponding to the start of this segment. 
     */
    protected int startOff = 0;
    
    /** 
     * Get the offset in the document corresponding to the start of this 
     * segment. 
     */
    public int getStartOff() {return startOff;}
    
    /**
     * Set the offset in the document corresponding to the start of 
     * this segment. 
     */
    public void setStartOff(int start) {startOff = start;}
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /** 
     * The offset in the document corresponding to the end of this segment. 
     */
    protected int endOff = 0;
    
    /** 
     * Get the offset in the document corresponding to the end of this 
     * segment. 
     */
    public int getEndOff() {return endOff;}
    
    /** 
     * Set the offset in the document corresponding to the end of this 
     * segment. 
     */
    public void setEndOff(int end) {endOff = end;}
  
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */

    /** 
     * The effect instance (inculding an indication of which effect is being
     * applied, along with parameter values) that this chuck is controlled
     * by.
     */
    protected EffectInstanceDescriptor effectInst = null;
    /** 
     * Get the effect instance (inculding an indication of which effect is being
     * applied, along with parameter values) that this chuck is controlled
     * by.
     */
    public EffectInstanceDescriptor getEffectInst() {return effectInst;}
    /** 
     * Set the effect instance (inculding an indication of which effect is being
     * applied, along with parameter values) that this chuck is controlled
     * by.
     */
    public void setEffectInst(EffectInstanceDescriptor effInst) 
      {effectInst = effInst;}

    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */    
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */    
    /* Constructors */
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */  
    
    /** Full constructor */
    public EffectSegment(
        StyledDocument doc, 
        int start, int end, 
        EffectInstanceDescriptor effect)
    {
        setDocument(doc);
        setStartOff(start);
        setEndOff(end);
        setEffectInst(effect);
    }
        
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */ 
    
    /** Default Constructor */
    public EffectSegment() { }
            
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */ 
    /* Methods */   
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */ 

    /** Utility method to extract the effect for a given document element */
    protected static EffectInstanceDescriptor getEffectForElem(Element elm)
    {
        // pull out the attribute set associated with the element
        AttributeSet attrs = elm.getAttributes();
        
        // walk through the attribute set looking for an effect instance 
        for (Enumeration en = attrs.getAttributeNames(); en.hasMoreElements(); ) 
        {
            // is it one of ours (has an EffectInstance descriptor for its attribute name & value)
            Object nm = en.nextElement();
            if (nm instanceof EffectInstanceDescriptor) 
            {
                Object val = attrs.getAttribute(nm);
                if (val instanceof EffectInstanceDescriptor)
                    return (EffectInstanceDescriptor)val;
            }
        }
        // no effect is there...
        return null;
    }
           
    /** Utility method to extract the effect at a given position in a document */
    protected static EffectInstanceDescriptor getEffectAtPos(StyledDocument fromDoc, int atPos)
    {
        // extract the element and use that to get the effect
        return getEffectForElem(fromDoc.getCharacterElement(atPos));
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */     
    
    public static EffectSegment buildNextSegment(
      StyledDocument fromDoc, 
      int startPos)
    {
        // sanity check
        if (fromDoc == null || startPos < 0 || startPos >= fromDoc.getLength()) 
            return null;
        
        // fill in what we know
        EffectSegment result = new EffectSegment();
        result.setDocument(fromDoc);
        result.setStartOff(startPos);
        result.setEndOff(startPos); // in case we are empty
        
        // extract the effect instance (if any) associated with that element
        result.setEffectInst(getEffectAtPos(fromDoc,startPos));
        
        // walk down elements of the document until we get to another effect
        Element elm;
        for (int pos = startPos; pos < fromDoc.getLength(); pos = elm.getEndOffset())
        {
            // extract the current element and see if it has the same controlling effect
            elm = fromDoc.getCharacterElement(pos);
            if (result.getEffectInst() == getEffectForElem(elm))
            {
                // same controlling effect so extend result to include this
                result.setEndOff(elm.getEndOffset());
            }
            else
            {
                // different effect for this element, so we are done 
                break;
            }
        }
        return result;
    }
      
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */  
}

