package KTEditor;

import javax.swing.text.LabelView;
import javax.swing.text.Element;
import javax.swing.text.View;

// xx clean up
import java.awt.*;
import javax.swing.event.*;

/**
 * This subclass of LabelView adds extra leading under the text elements
 * it provides a view for, but otherwise acts like its subclass.  Extra 
 * leading is provided by adding to the value returned by getPerferreSpan 
 * when called for the y axis.
 */
public class ExtraLeadingLabelView extends LabelView {


    /** Amount of extra leading that this view adds */
    protected float extraLeading = 10.0f;

    /** Get the amount of extra leading that this view adds */
    public float getExtraLeading() {return extraLeading;}

    /** Set the amount of extra leading that this view adds */
    public void setExtraLeading(float extraLead) {extraLeading = extraLead;}

    /**
     * Constructs a new view wrapped on an element.
     *
     * @param elem the element
     */
    public ExtraLeadingLabelView(Element elem, float extraLead) {
	super(elem);
	setExtraLeading(extraLead);
    }

    /* *
     * Fetches the <code>FontMetrics</code> used for this view.
     * @deprecated FontMetrics are not used for glyph rendering
     *  when running in the Java2 SDK.
     */
    /** may need to hack this... xx
    protected FontMetrics getFontMetrics() {
	sync();
	return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }
    */

    /**
     * Determines the preferred span for this view along an
     * axis.  When this gets called with View.Y_AXIS, we add
     * our extra leading into the result
     *
     * @param axis may be either View.X_AXIS or View.Y_AXIS
     * @return   the span the view would like to be rendered into >= 0.
     *           Typically the view is told to render into the span
     *           that is returned, although there is no guarantee.  
     *           The parent may choose to resize or break the view.
     */
    public float getPreferredSpan(int axis) {
        return super.getPreferredSpan(axis) + 
            ((axis == View.Y_AXIS)?getExtraLeading(): 0); 
    }

}

