package KTEditor;

import java.awt.*;
import java.awt.event.*;
import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Vector;
import java.beans.PropertyChangeListener;
import java.io.*;

import javax.swing.*;
import javax.swing.text.*;
import javax.swing.event.*;
import javax.swing.undo.*;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.filechooser.FileFilter;
import java.text.DecimalFormat;

import kinetic.Sequence;
import kinetic.util.MovieEncoder.SequenceExporter;

//xx this file still a bit of a mess, need to document better, reorganize placement of
//   routines and consider moving some inner classes out
/**
 */
public class KTEdit extends javax.swing.JFrame {
    
    /**
     * The single instance of this class which is created by the static main
     * routine.
     */
    protected static KTEdit instance = null;
    
    /**
     * Return the single instance of this class (which is created by the
     * static main routine.
     */
    public static KTEdit getInstance() {return instance;}
    
    //xx write accessors for these
    protected JTextPane textPane;
    protected DefaultStyledDocument theDoc;
    protected String newline = "\n";
    protected Hashtable actions;
    
    // the effect we are currently editing.  this is the first (left-most)
    // effect that overlaps the current selection.  this will be null when there
    // is no effect applied within the selection area.
    EffectInstanceDescriptor currentEffectInstance = null;
    
    // placeholder controlUI for when we have no effect
    JComponent dummyEffectsControls = EffectInstanceDescriptor.buildParmBox(null);
    
    // the component we place the controls for the current effect into
    // this is set up by buildMainUI().
    JComponent effectControlContainer = null;
    
    // object that manages autofire of previews
    PreviewAutoFire autoFire = null;
    
    //undo helpers
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    protected UndoManager undo = new UndoManager();
    
    /** Default title for our frame */
    public final String frameTitle = "Kinedit (Kinetic Typography Editor)";
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    public KTEdit() {
        //some initial setup
        super();
        
        //Create and initialize the document for the text area.
        theDoc = new DefaultStyledDocument();
        initDocument(theDoc);
        setTitle("Untitled" + " - " + frameTitle);
        
        // Build the main interface
        buildMainUI(theDoc);
        
        // Build the preview window
        preview = new PreviewManager();
        preview.buildPreviewUI();
        preview.showPreviewUI();
        //preview.installNewPreview(theDoc,true);
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    protected void buildMainUI(StyledDocument doc) {
        //Create the text pane and configure it.
        textPane = new ExtraLeadingTextPane();
        textPane.setDocument(doc);
        
        // we use a custom highlighter which produces said output between the lines
        textPane.setHighlighter(new TagHighlighter());
        textPane.setCaretPosition(0);
        textPane.setMargin(new Insets(5,5,5,5));
        
        // scroller that it goes in
        JScrollPane scrollPane = new JScrollPane(textPane);
        scrollPane.setPreferredSize(new Dimension(600, 450));
        
        Box effectParmBox = Box.createHorizontalBox();
        effectControlContainer = effectParmBox;
        effectParmBox.add(dummyEffectsControls);
        
        JScrollPane scrollPaneForParms = new JScrollPane(effectParmBox);
        // Make sure the thing doesn't get squashed in layout
        scrollPaneForParms.setMinimumSize(new Dimension(150,125));
        
        //Create a split pane for the change log and the text area.
        JSplitPane splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT,
        scrollPaneForParms, scrollPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setContinuousLayout(true);
        splitPane.setDividerLocation(175);
        
        //Add the components to the frame.
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add(splitPane, BorderLayout.CENTER);
        setContentPane(contentPane);
        
        EffectDescriptor[] effectsList = KTEngineInterface.getEffectsList();
        TagDescriptor[] tagsList = KTEngineInterface.getTagsList();
        
        //Set up the menu bar.
        createActionTable(textPane);
        JMenu fileMenu = createFileMenu();
        JMenu editMenu = createEditMenu();
        JMenu styleMenu = createStyleMenu();
        JMenu fontMenu = createFontMenu();
        JMenu sizeMenu = createSizeMenu();
        JMenu effectsMenu = createEffectsMenu(effectsList);
        JMenu tagsMenu = createTagsMenu(tagsList);
        JMenuBar mb = new JMenuBar();
        mb.add(fileMenu);
        mb.add(editMenu);
        mb.add(fontMenu);
        mb.add(sizeMenu);
        mb.add(styleMenu);
        mb.add(effectsMenu);
        mb.add(tagsMenu);
        setJMenuBar(mb);
        
        //Add some key bindings to the keymap.
        /*** dead code ****
         * addKeymapBindings();
         ****/
        
        // Add listener to put up editor for current effect as caret moves
        CaretListener tracker = new EffectAtCaretTracker();
        textPane.addCaretListener(tracker);
        
        //Start watching for undoable edits and caret changes.
        doc.addUndoableEditListener(new MyUndoableEditListener());
        
        // set up the preview autofire object to get notification of all edits
        if (autoFire == null)
            autoFire = new PreviewAutoFire();
        doc.addDocumentListener(autoFire);
    }
    
    public void installNewDocument(StyledDocument doc, String fileName) {
        // make a sensible name if we don't have one
        if (fileName == null) fileName = "Untitled";
        this.setTitle(fileName + " - " + frameTitle);
        
        // attachethe document to our pane
        textPane.setDocument(doc);
        theDoc = (DefaultStyledDocument)doc;
        
        // Add listener to put up editor for current effect as caret moves
        CaretListener tracker = new EffectAtCaretTracker();
        textPane.addCaretListener(tracker);
        
        //Start watching for undoable edits and caret changes.
        doc.addUndoableEditListener(new MyUndoableEditListener());
        
        // set up the preview autofire object to get notification of all edits
        if (autoFire == null)
            autoFire = new PreviewAutoFire();
        doc.addDocumentListener(autoFire);
        
        // move cursor to front
        textPane.setCaretPosition(0);
        
        preview.installNewPreview(doc,true);
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /** The object that manages our preview */
    protected PreviewManager preview = null;
    
    /** Get the object that manages our preview */
    public PreviewManager getPreview() {return preview;}
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /**
     * Create a new preview animation from the document being edited,
     * optionally resetting the animation time to 0.
     */
    public void installNewPreview(boolean resetPreviewTime) {
        preview.installNewPreview(theDoc,resetPreviewTime);
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    protected JFileChooser filePicker = null;
    
    protected boolean curFileSaved = false;
    
    protected String curFilePath = null;
    
    protected String curFileName = null;
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    public boolean overwriteGuard(File wFile) {
        // if the file doesn't already exist we are fine
        if (!wFile.exists()) return true;
        
        // put up an overwite confirm dialog
        int userSays = JOptionPane.showConfirmDialog(this,
        wFile.getName() + " already exists. Replace it?", "Replace?",
        JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
        
        // we are clean if and only if they press yes
        return (userSays == JOptionPane.YES_OPTION);
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /**
     * Save to a file picked by the user. Returns true if the save was sucessful
     * and not aborted by the user.
     */
    public boolean saveDocumentAs() {
        File oFile = null;
        
        try { // FileNotFoundException, IOException xx
            // make sure we have a file chooser to work with
            if (filePicker == null) filePicker = new JFileChooser();
            
            // run he file dialog
            int returnV = filePicker.showSaveDialog(this);
            
            // do we proceed?
            if (returnV == JFileChooser.APPROVE_OPTION) {
                // get the file they selected
                oFile = filePicker.getSelectedFile();
                
                // if it exists already confirm overwrite
                if (overwriteGuard(oFile)) {
                    // create the output infrastructure around the file they set
                    FileOutputStream ostream = new FileOutputStream(oFile);
                    ObjectOutputStream objStream = new ObjectOutputStream(ostream);
                    
                    // serialize the document out to that file
                    objStream.writeObject(theDoc);
                    
                    // flush and close
                    objStream.flush();
                    ostream.close();
                    
                    // note that file was saved, note name, and return as not aborted
                    curFileSaved = true;
                    curFileName = oFile.getName();
                    this.setTitle(curFileName + " - " + frameTitle);
                    curFilePath = oFile.getAbsolutePath();
                    return true;
                }
                else {
                    // overwrite cancelled, return as aborted
                    return false;
                }
            }
            else {
                // save was cancelled return as aborted
                return false;
            }
        } catch (FileNotFoundException fnfe) {
            // tell the user we couldn't find the file
            JOptionPane.showMessageDialog(this, "File could not be written.  \"" +
            ((oFile==null)?"File":oFile.getName()) + "\" is open in another application or not found.",
            "File Not Saved", JOptionPane.WARNING_MESSAGE);
            return false;
        } catch (NotSerializableException nse) {
            // tell the user we blew it
            JOptionPane.showMessageDialog(this, "File could not be written.  " +
            "Internal I/O error while writing \"" +
            ((oFile==null)?"File":oFile.getName()) + "\".",
            "File Not Saved", JOptionPane.WARNING_MESSAGE);
            // put out more debug for us
            System.out.println("Internal error during save => "+nse);//xx
            nse.printStackTrace();//xx
            return false;
        } catch (IOException ioe) {
            // tell the user about the failure
            JOptionPane.showMessageDialog(this, "File could not be written.  " +
            "I/O error while writing \"" +
            ((oFile==null)?"File":oFile.getName()) + "\".",
            "File Not Saved", JOptionPane.WARNING_MESSAGE);
            return false;
        }
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /**
     * Save to the file we got the document from. If there was no such file,
     * we call saveDocumentAs() instead.  Returns true if the save was sucessful
     * and not aborted by the user.
     */
    public boolean saveDocument() {
        File oFile = null;
        
        // if we don't have a name pass it on to save as
        if (curFileName == null || curFilePath == null)
            return saveDocumentAs();
        
        try {
            // create a file with existing path
            oFile = new File(curFilePath);
            
            // create the output infrastructure around the file
            FileOutputStream ostream = new FileOutputStream(oFile);
            ObjectOutputStream objStream = new ObjectOutputStream(ostream);
            
            // serialize the document out to that file
            objStream.writeObject(theDoc);
            
            // flush and close
            objStream.flush();
            ostream.close();
            
            // note that file was saved and return as not aborted
            curFileSaved = true;
            return true;
            
        } catch (FileNotFoundException fnfe) {
            // tell the user we couldn't find the file
            JOptionPane.showMessageDialog(this, "File could not be written.  \"" +
            ((oFile==null)?"File":oFile.getName()) + "\" not found.",
            "File Not Saved", JOptionPane.WARNING_MESSAGE);
            return false;
        } catch (NotSerializableException nse) {
            // tell the user we blew it
            JOptionPane.showMessageDialog(this, "File could not be written.  " +
            "Internal I/O error while writing \"" +
            ((oFile==null)?"File":oFile.getName()) + "\".",
            "File Not Saved", JOptionPane.WARNING_MESSAGE);
            // put out more debug for us
            System.out.println("Internal error during save => "+nse);//xx
            nse.printStackTrace();//xx
            return false;
        } catch (IOException ioe) {
            // tell the user about the failure
            JOptionPane.showMessageDialog(this, "File could not be written.  " +
            "I/O error while writing \"" +
            ((oFile==null)?"File":oFile.getName()) + "\".",
            "File Not Saved", JOptionPane.WARNING_MESSAGE);
            return false;
        }
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /**
     * Make sure that the current document is saved.  If the current document
     * has been saved since the last change, this returns true.  If not, we
     * put up a dialog to let them save it, or cancel the operation.  If they
     * save or choose not to save, then true is returned indicating its safe
     * to proceed.  If they ask to cancel, false is returned.
     */
    public boolean unsavedGuard() {
        // if we are already saved, all is well
        if (curFileSaved) return true;
        
        String curName = curFileName;
        if (curName == null) curName = "Untitled";
        
        // throw up a guard dialog
        int userSays = JOptionPane.showConfirmDialog(this,
        "Save changes to " + curName + "?",
        "Save changes?", JOptionPane.YES_NO_CANCEL_OPTION);
        // if user cancels or closes, we return abort inidcator
        if (userSays == JOptionPane.CANCEL_OPTION || userSays == JOptionPane.CLOSED_OPTION)
            return false;
        
        // if the user says yes do the save
        if (userSays == JOptionPane.YES_OPTION) {
            // return the abort status from saving the document
            return saveDocument();
        }
        
        // we can proceed to overwrite
        return true;
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    public void openDocument() {
        File iFile = null;
        
        // make sure we are not about to overwrite an unsaved document without
        // an ok from the user
        if (!unsavedGuard()) return;
        
        try {
            // make sure we have a file chooser to work with
            if (filePicker == null) filePicker = new JFileChooser();
            
            // run the file dialog
            int returnV = filePicker.showOpenDialog(this);
            
            // do we proceed?
            if (returnV == JFileChooser.APPROVE_OPTION) {
                // create the output infrastructure around the file they set
                iFile = filePicker.getSelectedFile();
                FileInputStream istream = new FileInputStream(iFile);
                ObjectInputStream objStream = new ObjectInputStream(istream);
                
                // unserialize a document out of that stream and then close it
                StyledDocument newDoc = (StyledDocument)objStream.readObject();
                istream.close();
                
                // install the new document
                installNewDocument(newDoc, iFile.getName());
                
                // new file, not edited yet
                curFileSaved = true;
                curFileName = iFile.getName();
                curFilePath = iFile.getAbsolutePath();
            }
            else {
                // open was cancelled, do nothing
            }
        } catch (FileNotFoundException fnfe) {
            // tell the user we couldn't find the file
            JOptionPane.showMessageDialog(this, "File could not be opened.  \"" +
            ((iFile==null)?"File":iFile.getName()) + "\" not found.",
            "Unable To Open", JOptionPane.WARNING_MESSAGE);
        } catch (IOException ioe) {
            // tell the user about the failure
            JOptionPane.showMessageDialog(this, "File could not be opened.  \"" +
            ((iFile==null)?"File":iFile.getName()) +
            "\" cannot be read as a Kinedit document.",
            "Unable to Open", JOptionPane.WARNING_MESSAGE);
        } catch (ClassNotFoundException cnfe) {
            // tell the user about the failure
            JOptionPane.showMessageDialog(this, "File could not be opened.  \"" +
            ((iFile==null)?"File":iFile.getName()) +
            "\" is corrupted or from an incompatable version of Kinedit.",
            "Unable to Open", JOptionPane.WARNING_MESSAGE);
        }
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    public class dotMovFilter extends FileFilter {
        public boolean accept(File f) {
            return f!= null && f.getName().endsWith(".mov");
        }
        public String getDescription() {
            return "QuickTime movie files (*.mov)";
        }
    }
    
    protected JFileChooser exportFilePicker = null;
    protected JFrame exportFrame = null;
    protected JPanel exportCanvas = null;
    protected FileFilter movFilter = new dotMovFilter();
    
    public void exportQT() {
        File oFile = null;
        
        try {
            // make sure we have a file chooser to work with
            if (exportFilePicker == null) {
                exportFilePicker = new JFileChooser();
                exportFilePicker.addChoosableFileFilter(movFilter);
            }
            
            // always filter to .mov by default
            exportFilePicker.setFileFilter(movFilter);
            
            // run the file dialog
            int returnV = exportFilePicker.showSaveDialog(this);
            
            // do we proceed?
            if (returnV == JFileChooser.APPROVE_OPTION) {
                // get the file they selected
                oFile = exportFilePicker.getSelectedFile();
                
                // file name must end in .mov
                if (!oFile.getName().endsWith(".mov")) {
                    // force a .mov at the end
                    oFile = new File(oFile.getPath()+".mov");
                }
                
                // if it exists already confirm overwrite
                if (overwriteGuard(oFile)) {
                    // make sure we have a frame to watch the export in
                    if (exportFrame == null) {
                        exportFrame = new JFrame("QuickTime Export Frames");
                        exportFrame.setLocation(new Point(360,0));
                        exportFrame.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
                        exportCanvas = new JPanel();
                        exportCanvas.setBackground(Color.white);
                        exportCanvas.setMinimumSize(new Dimension(640,480));
                        exportCanvas.setPreferredSize(new Dimension(640,480));
                        exportFrame.getContentPane().add(exportCanvas);
                        exportFrame.pack();
                    }
                    // exportFrame.setVisible(true);  xx kill dead code above
                    
                    // make sure a sequence is installed in the previewer
                    installNewPreview(false);
                    Sequence seq = preview.getCurrentPreviewSequence();
                    
                    // force the preview to stop
                    preview.pausePreview();
                    
                    // get the sequence duration, change default to 0, and compute seconds
                    long seqDur = preview.getSequenceDuration();
                    if (seqDur == Long.MAX_VALUE) seqDur = 0;
                    int durSec = (int)Math.ceil(seqDur/1000.0);
                    
                    float fps = 30.0f; //xx later let the user pick
                    
                    
                    // export the sequence
                    float quality = 0.25f; //xx kill hard code
                    SequenceExporter exporter =
                    new SequenceExporter(preview.getPreviewCanvas(), seq, durSec, fps);
                    exporter.setMotionBlur(15);
                    exporter.export("file:" + oFile.getPath(), quality);
                    
                    exportFrame.setVisible(false);
                }
            }
        } catch (Exception e) {
            // xx fix this later to deal with more specific exceptions
            //xx extra debug for us for now
            e.printStackTrace();
            
            // tell the user
            JOptionPane.showMessageDialog(this, "\"" +
            ((oFile==null)?"File":oFile.getName()) +
            "\" could not be exported. (" + e +")",
            "Export Failed", JOptionPane.WARNING_MESSAGE);
            if (exportFrame != null) exportFrame.setVisible(false);
        }
    }
    
    /*--------------------------------------------------------------------------*/
    
    protected static int testCount = 0;
    
    public class testAction extends StyledEditorKit.StyledTextAction {
        
        /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
        
        public testAction(String name) {
            super(name);
            putValue(Action.ACCELERATOR_KEY,
            KeyStroke.getKeyStroke(new Character('T'),InputEvent.CTRL_MASK));
        }
        
        /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
        
        public void actionPerformed(ActionEvent actEvt) {
            // Pull the editor, document, and editorkit and ensure they exist
            JEditorPane edPane = getEditor(actEvt);
            if (edPane == null) return;
            StyledEditorKit edKit = getStyledEditorKit(edPane);
            if (edKit == null) return;
            DefaultStyledDocument doc = (DefaultStyledDocument)edPane.getDocument();
            if (doc == null) return;
            
            testCount++;
            
            if (testCount == 1){
                System.out.println("test #1");
            } else if (testCount == 2) {
                System.out.println("test #2");
            } else if (testCount == 3) {
                System.out.println("test #3");
            } else if (testCount == 4) {
                System.out.println("test #4");
            } else if (testCount == 5) {
                System.out.println("test #5");
            } else if (testCount == 6) {
                System.out.println("test #6");
            } else if (testCount == 7) {
                System.out.println("test #7");
            } else if (testCount == 8) {
                System.out.println("test #8");
            } else if (testCount == 9) {
                System.out.println("test #9");
            } else if (testCount == 10) {
                System.out.println("test #10");
                
                System.out.println("resetting to test #1...");
                testCount = 0;
            }
        }
        
        /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
        
    }
    
    /*--------------------------------------------------------------------------*/
    
    protected class EffectAtCaretTracker implements CaretListener {
        
        /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
        
        /**
         * Recieve notification of caret (selection) changes.  We act on that by
         * setting the current effect instance to the first effect intersecting the
         * selection and installing the accompanying user interface into to overall
         * UI.
         */
        public void caretUpdate(CaretEvent caretEvent) {
            //remember the old effect so we can avoid updates if there is no change
            EffectInstanceDescriptor oldEffect = currentEffectInstance;
            
            //Get the location of the current selection in the text.
            int startPos = caretEvent.getDot();
            int endPos = caretEvent.getMark();
            if (startPos > endPos) {
                int temp = startPos;
                startPos = endPos;
                endPos = temp;
            }
            // if we have just a caret and no selection make this look like a one character
            // selection so we look at the chunk the caret is before
            if (startPos == endPos) endPos++;  //xx for internationalization should look up direction
            
            // walk over the chunks of the document looking for first effect
            Element elm;
            for (int pos = startPos; pos < endPos; pos = elm.getEndOffset()) {
                elm = theDoc.getCharacterElement(pos);
                AttributeSet elmAttrs = elm.getAttributes();
                
                // look at each attribute set here and see if its an effect
                for (Enumeration en = elmAttrs.getAttributeNames(); en.hasMoreElements(); ) {
                    Object attr = en.nextElement();
                    
                    // is it an effect and not set to false
                    if (attr instanceof EffectInstanceDescriptor &&
                    elmAttrs.getAttribute(attr) instanceof EffectInstanceDescriptor) {
                        // we found one, that establishes the editor
                        currentEffectInstance = (EffectInstanceDescriptor)attr;
                        if (currentEffectInstance != oldEffect) {
                            effectControlContainer.removeAll();
                            effectControlContainer.add(currentEffectInstance.getControlUI());
                            effectControlContainer.revalidate();
                            effectControlContainer.repaint();
                        }
                        // we are all done
                        return;
                    }
                }
                
            }
            // no effect establish the default
            currentEffectInstance = null;
            if (currentEffectInstance != oldEffect) {
                effectControlContainer.removeAll();
                effectControlContainer.add(dummyEffectsControls);
                effectControlContainer.revalidate();
                effectControlContainer.repaint();
            }
        }
        
        /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
        
        public EffectAtCaretTracker() {
            // nothing to do here for now
        }
        
        /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    }
    
    
    /*--------------------------------------------------------------------------*/
    
    /**** DEAD CODE *****/
    //This listens for and reports caret movements.
    protected class CaretListenerLabel extends JLabel implements CaretListener {
        
        /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
        
        public CaretListenerLabel(String label) {
            super(label);
        }
        
        /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
        
        public void caretUpdate(CaretEvent e) {
            //Get the location in the text.
            int dot = e.getDot();
            int mark = e.getMark();
            if (dot == mark) {  // no selection
                try {
                    Rectangle caretCoords = textPane.modelToView(dot);
                    //Convert it to view coordinates.
                    if (caretCoords != null)
                        setText("caret: text position: " + dot
                        + ", view location = ["
                        + caretCoords.x + ", "
                        + caretCoords.y + "]"
                        + newline);
                } catch (BadLocationException ble) {
                    setText("caret: text position: " + dot + newline);
                }
            } else if (dot < mark) {
                setText("selection from: " + dot
                + " to " + mark + newline);
            } else {
                setText("selection from: " + mark
                + " to " + dot + newline);
            }
        }
        
    }
    /*** END DEAD CODE ***/
    /*--------------------------------------------------------------------------*/
    
    //This one listens for edits that can be undone.  xx rename this...
    protected class MyUndoableEditListener implements UndoableEditListener {
        
        /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
        
        public void undoableEditHappened(UndoableEditEvent e) {
            //Remember the edit and update the menus.
            undo.addEdit(e.getEdit());
            undoAction.updateUndoState();
            redoAction.updateRedoState();
        }
    }
    
    /*--------------------------------------------------------------------------*/
    
    /**
     * Indicate that an edit (something that changes the preview that should be
     * shown and/or the save status) has occured.  This resets the
     * PreviewAutoFire timer that we use to fire off automatic previews after
     * a short delay and updates the saved status.
     */
    public void editOccured() {
        curFileSaved = false;
        if (autoFire!= null) autoFire.editOccurred();
    }
    
    protected class PreviewAutoFire implements DocumentListener, ActionListener {
        
        /** Delay after the last edit to automatically restart the preview */
        protected final int autoFireDelay = 1000*2;
        
        /**
         * Timer that we use to count off the delay after the last edit.  Each
         * time we get a new edit this starts counting over.  If we time out then
         * we are given a notification and will fire the preview.
         */
        protected Timer autoFireTimer = new Timer(autoFireDelay, this);
        
        /**
         * Construct a preview autofire object and initialize, but don't start
         * its timer.  The timer will be started as a result of the first edit.
         */
        public PreviewAutoFire() {
            /** set up the timer and make it a one shot */
            autoFireTimer = new Timer(autoFireDelay, this);
            autoFireTimer.setRepeats(false);
        }
        
        /** Recieve notification of an edit */
        public void insertUpdate(DocumentEvent e) {
            editOccurred();
        }
        
        /** Recieve notification of an edit */
        public void removeUpdate(DocumentEvent e) {
            editOccurred();
        }
        
        /** Recieve notification of an edit */
        public void changedUpdate(DocumentEvent e) {
            editOccurred();
        }
        
        /**
         * Respond to the fact that an edit has occured.  This resets the autofire
         * timer as well as the saved status of the file.  The timer will then
         * fire if no edits have occurred in autoFireDelay ms.
         */
        public void editOccurred() {
            autoFireTimer.restart();
            curFileSaved = false;
        }
        
        /** Respond to the autofire timer firing.  This means that there has been
         * at least one edit since we last fired but that no additional edits have
         * occurred in the last autoFireDelay ms.  We respond to this by starting a
         * new preview (but only if isAuto() is set within the preview object).
         */
        public void actionPerformed(ActionEvent e) {
            // Only do something if the preview is set to take autofires
            if (preview.isAuto()) {
                // Fire off the preview...
                
                // put in a new preview sequence
                preview.installNewPreview(theDoc);
                
                // make sure the preview UI is up and restart the preview
                preview.showPreviewUI();
                preview.restartPreview();
            }
        }
    }
    
    /*--------------------------------------------------------------------------*/
    /**** DEAD CODE *****
     * //Add a couple of emacs key bindings to the key map for navigation.
     * protected void addKeymapBindings() {
     * //Add a new key map to the keymap hierarchy.
     * Keymap keymap = textPane.addKeymap("MyEmacsBindings",
     * textPane.getKeymap());
     *
     * //Ctrl-b to go backward one character
     * Action action = getActionByName(DefaultEditorKit.backwardAction);
     * KeyStroke key = KeyStroke.getKeyStroke(KeyEvent.VK_B, Event.CTRL_MASK);
     * keymap.addActionForKeyStroke(key, action);
     *
     * //Ctrl-f to go forward one character
     * action = getActionByName(DefaultEditorKit.forwardAction);
     * key = KeyStroke.getKeyStroke(KeyEvent.VK_F, Event.CTRL_MASK);
     * keymap.addActionForKeyStroke(key, action);
     *
     * //Ctrl-p to go up one line
     * action = getActionByName(DefaultEditorKit.upAction);
     * key = KeyStroke.getKeyStroke(KeyEvent.VK_P, Event.CTRL_MASK);
     * keymap.addActionForKeyStroke(key, action);
     *
     * //Ctrl-n to go down one line
     * action = getActionByName(DefaultEditorKit.downAction);
     * key = KeyStroke.getKeyStroke(KeyEvent.VK_N, Event.CTRL_MASK);
     * keymap.addActionForKeyStroke(key, action);
     *
     * textPane.setKeymap(keymap);
     * }
     ***** END DEAD CODE ****/
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    //Create the file menu
    protected JMenu createFileMenu() {
        JMenu menu = new JMenu("File");
        
        int i = 0;
        menu.add("New...");
        menu.getItem(i).setAccelerator(
        KeyStroke.getKeyStroke(new Character('N'),InputEvent.CTRL_MASK));
        menu.getItem(i++).setEnabled(false);
        
        menu.add("Open...");
        menu.getItem(i).setAccelerator(
        KeyStroke.getKeyStroke(new Character('O'),InputEvent.CTRL_MASK));
        menu.getItem(i).addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                openDocument();
            }
        });
        i++;
        
        menu.addSeparator();    i++;
        
        menu.add("Save");
        menu.getItem(i).setAccelerator(
        KeyStroke.getKeyStroke(new Character('S'),InputEvent.CTRL_MASK));
        menu.getItem(i).addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                saveDocument();
            }
        });
        i++;
        
        menu.add("Save As...");
        menu.getItem(i).addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                saveDocumentAs();
            }
        });
        i++;
        
        menu.add("Export QuickTime Movie...");
        menu.getItem(i).addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                exportQT();
            }
        });
        i++;
        
        menu.addSeparator();    i++;
        
        menu.add("Exit");
        menu.getItem(i).setAccelerator(
        KeyStroke.getKeyStroke(new Character('Q'),InputEvent.CTRL_MASK));
        menu.getItem(i).addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent Evt) {
                // do a guarded exit
                if (unsavedGuard()) System.exit(0);
            }
        });
        i++;
        
        menu.addSeparator();    i++;
        menu.add(new KTEdit.testAction("Test"));
        //menu.getItem(i).setAccelerator(
        //       KeyStroke.getKeyStroke(new Character('T'),InputEvent.CTRL_MASK));
        i++;
        return menu;
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    //Create the edit.
    protected JMenu createEditMenu() {
        int itm = 0;
        
        JMenu menu = new JMenu("Edit");
        
        //Undo and redo are actions of our own creation.
        undoAction = new UndoAction();
        menu.add(undoAction);
        menu.getItem(itm).setAccelerator(
        KeyStroke.getKeyStroke(new Character('Z'), InputEvent.CTRL_MASK));
        itm++;
        
        redoAction = new RedoAction();
        menu.add(redoAction);
        menu.getItem(itm).setAccelerator(
        KeyStroke.getKeyStroke(new Character('Y'), InputEvent.CTRL_MASK));
        itm++;
        
        menu.addSeparator(); itm++;
        
        //These actions come from the default editor kit.
        //Get the ones we want and stick them in the menu.
        menu.add(getActionByName(DefaultEditorKit.cutAction));
        menu.getItem(itm).setText("Cut");
        menu.getItem(itm).setAccelerator(
        KeyStroke.getKeyStroke(new Character('X'), InputEvent.CTRL_MASK));
        itm++;
        menu.add(getActionByName(DefaultEditorKit.copyAction));
        menu.getItem(itm).setText("Copy");
        menu.getItem(itm).setAccelerator(
        KeyStroke.getKeyStroke(new Character('C'), InputEvent.CTRL_MASK));
        itm++;
        menu.add(getActionByName(DefaultEditorKit.pasteAction));
        menu.getItem(itm).setText("Paste");
        menu.getItem(itm).setAccelerator(
        KeyStroke.getKeyStroke(new Character('C'), InputEvent.CTRL_MASK));
        itm++;
        
        menu.addSeparator(); itm++;
        
        menu.add("Show Preview");
        // set up action to put up the preview window and start animation
        menu.getItem(itm).addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                // update and fire off the preview
                preview.installNewPreview(theDoc);
                preview.showPreviewUI();
                preview.toFront();
                preview.restartPreview();
            }
        });
        itm++;
        
        menu.addSeparator(); itm++;
        
        menu.add(getActionByName(DefaultEditorKit.selectAllAction));
        menu.getItem(itm).setText("Select All");
        menu.getItem(itm).setAccelerator(
        KeyStroke.getKeyStroke(new Character('A'), InputEvent.CTRL_MASK));
        itm++;
        
        
        return menu;
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    //Create the style menu.
    protected JMenu createStyleMenu() {
        JMenu menu = new JMenu("Style");
        
        Action action = new WordScoped(new StyledEditorKit.BoldAction(),textPane);
        action.putValue(Action.NAME, "Bold");
        menu.add(action);
        
        action = new WordScoped(new StyledEditorKit.ItalicAction(),textPane);
        action.putValue(Action.NAME, "Italic");
        menu.add(action);
        
        menu.addSeparator();
        
        menu.add(new WordScoped(new StyledEditorKit.ForegroundAction("Black", Color.black),textPane));
        menu.add(new WordScoped(new StyledEditorKit.ForegroundAction("Light Gray", Color.lightGray),textPane));
        menu.add(new WordScoped(new StyledEditorKit.ForegroundAction("Gray", Color.gray),textPane));
        menu.add(new WordScoped(new StyledEditorKit.ForegroundAction("Dark Gray", Color.darkGray),textPane));
        
        menu.add(new WordScoped(new StyledEditorKit.ForegroundAction("Red", Color.red),textPane));
        menu.add(new WordScoped(new StyledEditorKit.ForegroundAction("Green", Color.green),textPane));
        menu.add(new WordScoped(new StyledEditorKit.ForegroundAction("Blue", Color.blue),textPane));
        menu.add(new WordScoped(new StyledEditorKit.ForegroundAction("Yellow", Color.yellow),textPane));
        menu.add(new WordScoped(new StyledEditorKit.ForegroundAction("Orange", Color.orange),textPane));
        menu.add(new WordScoped(new StyledEditorKit.ForegroundAction("Pink", Color.pink),textPane));
        menu.add(new WordScoped(new StyledEditorKit.ForegroundAction("Cyan", Color.cyan),textPane));
        menu.add(new WordScoped(new StyledEditorKit.ForegroundAction("Magenta", Color.magenta),textPane));
        
        return menu;
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    //Create the size menu
    protected JMenu createSizeMenu() {
        JMenu menu = new JMenu("Size");
        
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("9", 9),textPane));
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("10", 10),textPane));
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("11", 11),textPane));
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("12", 12),textPane));
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("13", 13),textPane));
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("14", 14),textPane));
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("16", 16),textPane));
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("18", 18),textPane));
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("20", 20),textPane));
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("24", 24),textPane));
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("28", 28),textPane));
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("32", 32),textPane));
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("36", 36),textPane));
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("40", 40),textPane));
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("48", 48),textPane));
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("56", 56),textPane));
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("64", 64),textPane));
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("72", 72),textPane));
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("80", 80),textPane));
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("90", 90),textPane));
        menu.add(new WordScoped(new StyledEditorKit.FontSizeAction("100", 100),textPane));
        return menu;
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    //Create the effects menu
    protected JMenu createEffectsMenu(EffectDescriptor[] effectsList) {
        JMenu menu = new JMenu("Effects");
        
        if (effectsList == null || effectsList.length == 0) {
            menu.add("No Effects Loaded");
            menu.getItem(0).setEnabled(false);
        }
        for (int i = 0; i < effectsList.length; i++) {
            menu.add(new WordScoped(new ToggleEffectAttribute(effectsList[i]),textPane));
        }
        return menu;
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    //Create the tags menu
    protected JMenu createTagsMenu(TagDescriptor[] tagsList) {
        JMenu menu = new JMenu("Markings");
        
        if (tagsList == null || tagsList.length == 0) {
            menu.add("No Tags Available");
            menu.getItem(0).setEnabled(false);
        }
        for (int i = 0; i < tagsList.length; i++) {
            menu.add(new WordScoped(new ToggleTagAttribute(tagsList[i]),textPane));
        }
        return menu;
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    //Create the font menu
    protected JMenu createFontMenu() {
        JMenu menu = new JMenu("Font");
        
        int i = 0;
        menu.add("Portable Fonts"); menu.getItem(i++).setEnabled(false);
        menu.addSeparator(); i++;
        menu.add(new WordScoped(new StyledEditorKit.FontFamilyAction("Serif","Serif"),textPane)); i++;
        menu.add(new WordScoped(new StyledEditorKit.FontFamilyAction("SansSerif","SansSerif"),textPane)); i++;
        menu.add(new WordScoped(new StyledEditorKit.FontFamilyAction("Monospaced","Monospaced"),textPane)); i++;
        
        menu.addSeparator(); i++;
        menu.add("Local Fonts");     menu.getItem(i++).setEnabled(false);
        menu.addSeparator(); i++;
        
        String[] allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        if (allFonts != null) {
            if (allFonts.length < 20) {
                for (int nm = 0; nm < allFonts.length; nm++) {
                    menu.add(new WordScoped(new StyledEditorKit.FontFamilyAction(allFonts[nm],allFonts[nm]),textPane));
                    i++;
                }
            }
            else {
                addFontSubmenus(menu, allFonts);
            }
        }
        
        return menu;
    }
    
    /** Add submenus for fonts, one for each starting character */
    protected void addFontSubmenus(JMenu toMenu, String[] names) {
        Hashtable allSubs = new Hashtable();
        String chStr;
        
        // Create a sub-menu for each letter of the alphabet
        for (char ch = 'A'; ch <= 'Z'; ch++) {
            chStr = "" + ch;
            
            // create the submenu and save it till later
            JMenu thisSub = new JMenu(chStr);
            allSubs.put(chStr, thisSub);
        }
        
        // Walk down the fonts and put them in their submenus
        for (int i = 0; i < names.length; i++) {
            String start = names[i].substring(0,1).toUpperCase();
            JMenu aMenu = (JMenu) allSubs.get(start);
            if (aMenu != null)
                aMenu.add(new WordScoped(new StyledEditorKit.FontFamilyAction(names[i],names[i]),textPane));
        }
        
        // put the submenus in the result
        for (char ch = 'A'; ch <= 'Z'; ch++) {
            // look up the one with that letter
            chStr = "" + ch;
            JMenu thisSub = (JMenu) allSubs.get(chStr);
            
            // put it in, but disable it if its empty
            toMenu.add(thisSub);
            if (thisSub.getItemCount() == 0)
                toMenu.getItem(toMenu.getItemCount()-1).setEnabled(false);
        }
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /**
     * Initialize the document to some initial contents.  For now we this sets
     * up a bit of basic instructions for the user.
     */
    protected void initDocument(StyledDocument doc) {
        // after this the document shouldn't be considered saved
        curFileSaved = false;
        
        // set up the string and attributes to apply
        String initString[] = {
            "Type your message here...",
            "      Select text, then apply kinetic effects from the \"Effects\" " +
            "menu.  Within an effect, you can mark sections for special treatment using " +
            "the \"Markings\" menu, and set effect parameters "+
            "using the controls above the text."
        };
        SimpleAttributeSet[] attrs = initAttributes(initString.length);
        
        try {
            for (int i = 0; i < initString.length; i ++) {
                doc.insertString(doc.getLength(), initString[i] + newline,
                attrs[i]);
            }
        } catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text.");
        }
    }
    
    /** Set up the formatting attributes that go wit our initial text */
    protected SimpleAttributeSet[] initAttributes(int length) {
        //Hard-code some attributes.
        SimpleAttributeSet[] attrs = new SimpleAttributeSet[length];
        
        // default attributes to build from
        SimpleAttributeSet defaultAttrs = new SimpleAttributeSet();
        StyleConstants.setFontFamily(defaultAttrs, "SansSerif");
        StyleConstants.setFontSize(defaultAttrs, 24);
        
        int i = 0;
        
        attrs[i] = new SimpleAttributeSet(defaultAttrs);
        StyleConstants.setFontSize(attrs[i], 36);
        StyleConstants.setItalic(attrs[i], true);
        i++;
        
        // default attributes for the rest
        for ( ; i < attrs.length; i++)
            attrs[i] = new SimpleAttributeSet(defaultAttrs);
        
        return attrs;
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    //The following two methods allow us to find an
    //action provided by the editor kit by its name.
    private void createActionTable(JTextComponent textComponent) {
        actions = new Hashtable();
        Action[] actionsArray = textComponent.getActions();
        for (int i = 0; i < actionsArray.length; i++) {
            Action a = actionsArray[i];
            actions.put(a.getValue(Action.NAME), a);
        }
    }
    
    private Action getActionByName(String name) {
        return (Action)(actions.get(name));
    }
    
    /*--------------------------------------------------------------------------*/
    
    //xx move this to a file...
    
    /**
     * This action class provides a wrapper action which extends the current
     * selection within a document to include whole words, applies the wrapped
     * action, and then restores the original selection.  This basically forces
     * the wrapped action to apply to whole words.
     */
    public class WordScoped implements Action {
        /** The Action that we are wrapping */
        protected Action wrappee = null;
        
        /** Get the Action that we are wrapping */
        public Action getWrappee() {return wrappee;}
        
        /** Set the Action that we are wrapping */
        public void setWrappee(Action actToWrap) {wrappee = actToWrap;}
        
        /**
         * The editor this action is being applied within (used only if the
         * action events don't come from the editor itself).
         */
        JEditorPane defaultEditor = null;
        
        /** Construct a word scoped action by wrapping another action */
        public WordScoped(Action actionToWrap, JEditorPane forEditor) {
            wrappee = actionToWrap;
            defaultEditor = forEditor;
        }
        
        /**
         * Find and return the point extending forward from the given selection point
         * in the given document which will make the selection cover a full
         * word.
         */
        public /*static*/ int extendForward(StyledDocument doc, int sel) {
            try {
                int pos;
                int docEnd = doc.getLength();
                
                // if we end on a space don't extend past it
                if (sel > 0 && Character.isWhitespace(doc.getText(sel-1,1).charAt(0)))
                    return sel;
                
                // walk forward until we hit the end or a space
                for (pos = sel;
                pos <= docEnd && !Character.isWhitespace(doc.getText(pos,1).charAt(0));
                pos++) {
                    /* nothing to do */
                }
                // return the position at which we fall out of the loop
                return pos;
                
            } catch (BadLocationException ex) {
                // shouldn't happen, but if it does just return the original position
                return sel;
            }
        }
        
        /**
         * Find and return the point extending backward from the given selection point
         * in the given document which will make the selection cover a full
         * word.
         */
        public /*static*/ int extendBackward(StyledDocument doc, int sel) {
            try {
                int pos;
                
                // walk backward until we hit the start or right before a space
                for (pos = sel;
                pos > 0 && !Character.isWhitespace(doc.getText(pos-1,1).charAt(0));
                pos--) {
                    /* nothing to do */
                }
                // return the position at which we fall out of the loop
                return pos;
                
            } catch (BadLocationException ex) {
                // shouldn't happen, but if it does just return the original position
                return sel;
            }
        }
        
        /**
         * Produce the response for our action.  This will extend the scope of
         * the current selection to include whole words only, then apply the wrapped
         * action, then restore the selection.
         */
        public void actionPerformed(ActionEvent actionEvt) {
            // Pull the editorensure it exists
            JEditorPane edPane;
            if (actionEvt.getSource() instanceof JEditorPane)
                edPane = (JEditorPane)actionEvt.getSource();
            else // if this didn't come from the pane direct use the default
                edPane = defaultEditor;
            if (edPane == null) return;
            
            // get the document and editor kit and make sure they are ok
            StyledEditorKit edKit = (StyledEditorKit)edPane.getEditorKit();
            if (edKit == null) return;
            DefaultStyledDocument doc = (DefaultStyledDocument)edPane.getDocument();
            if (doc == null) return;
            
            // save the current selection
            int selStart = edPane.getSelectionStart();
            int selEnd = edPane.getSelectionEnd();
            int newStart = selStart;
            int newEnd = selEnd;
            
            // only extend the selection if its not a single point selection
            if (selStart != selEnd) {
                // extend the start of the selection backward to get a whole word
                newStart = extendBackward(doc, selStart);
                edPane.setSelectionStart(newStart);
                
                // extend the end of the selection forward to get a whole word
                newEnd = extendForward(doc, selEnd);
                edPane.setSelectionEnd(newEnd);
            }
            
            // wrapped action now does what it was going to do
            if (wrappee != null)
                wrappee.actionPerformed(actionEvt);
            
            // restore the selection
            edPane.setSelectionStart(selStart);
            edPane.setSelectionEnd(selEnd);
        }
        
        /** Add a property change listener.  We pass this direct to the wrapee. */
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            if (wrappee != null) wrappee.addPropertyChangeListener(listener);
        }
        
        /** Remove a property change listener.  We pass this direct to the wrappee */
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            if (wrappee != null) wrappee.removePropertyChangeListener(listener);
        }
        
        
        /**
         * Gets one of this object's properties using the associated key. We pass this
         * direct to the wrappee.
         */
        public Object getValue(String key) {
            if (wrappee != null)
                return wrappee.getValue(key);
            else
                return null;
        }
        
        /**
         * Sets one of this object's properties using the associated key.
         * If the value has changed, a PropertyChangeEvent is sent to listeners.
         * This is forwarded directly to the wrapped action.
         */
        public void putValue(String key, Object value) {
            if (wrappee != null) wrappee.putValue(key,value);
        }
        
        /**
         * Returns the enabled state of the Action (which we get
         * directly from the wrapped action).
         */
        public boolean isEnabled() {
            if (wrappee != null)
                return wrappee.isEnabled();
            else
                return false;
        }
        
        /**
         * Set the enabled state of the Action.  We pass this directly to the
         * wrapped action.
         */
        public void setEnabled(boolean b) {
            if (wrappee != null) wrappee.setEnabled(b);
        }
    }
    
    /*--------------------------------------------------------------------------*/
    
    class UndoAction extends AbstractAction {
        
        /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
        
        public UndoAction() {
            super("Undo");
            setEnabled(false);
        }
        
        /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
        
        public void actionPerformed(ActionEvent e) {
            try {
                undo.undo();
            } catch (CannotUndoException ex) {
                System.out.println("Unable to undo: " + ex);
                ex.printStackTrace();
            }
            updateUndoState();
            redoAction.updateRedoState();
        }
        
        /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
        
        protected void updateUndoState() {
            if (undo.canUndo()) {
                setEnabled(true);
                putValue(Action.NAME, undo.getUndoPresentationName());
            } else {
                setEnabled(false);
                putValue(Action.NAME, "Undo");
            }
        }
        
        /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    }
    
    /*--------------------------------------------------------------------------*/
    
    class RedoAction extends AbstractAction {
        
        /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
        
        public RedoAction() {
            super("Redo");
            setEnabled(false);
        }
        
        /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
        
        public void actionPerformed(ActionEvent e) {
            try {
                undo.redo();
            } catch (CannotRedoException ex) {
                System.out.println("Unable to redo: " + ex);
                ex.printStackTrace();
            }
            updateRedoState();
            undoAction.updateUndoState();
        }
        
        /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
        
        protected void updateRedoState() {
            if (undo.canRedo()) {
                setEnabled(true);
                putValue(Action.NAME, undo.getRedoPresentationName());
            } else {
                setEnabled(false);
                putValue(Action.NAME, "Redo");
            }
        }
        
        /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    }
    
    /*--------------------------------------------------------------------------*/
    
    /** Main routine.  This currently ignores its arguments. */
    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        } catch(Exception ex) { /* ignore */ }
        
        final KTEdit frame = new KTEdit();
        
        // handle our own closing, etc.
        frame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                // do a guarded exit
                if (frame.unsavedGuard()) System.exit(0);
            }
            public void windowActivated(WindowEvent e) {
                frame.textPane.requestFocus();
            }
        });
        
        // layout and show the top level window
        frame.pack();
        frame.setVisible(true);
        
        instance = frame;
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
}
