package KTEditor;

import java.io.Serializable;

/**
 *
 * Interface for all parameter values.
 * <p>
 * 
 * @author  Scott Hudson
 */
public interface ParameterValue extends Serializable {

    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */

    /** 
     * Set the value from an Object.  The actual class of this object must 
     * be a Double, Integer, or Boolean, or one handled specially by the 
     * class implementing the implementing actual class.  For Double,
     * Integer, or Boolean values, this should be equivalent to calling
     * the similarly typed method.
     */
    public void setValue(Object val);

    /** 
     * Set the value from a Double.  If necessary this may be truncated into
     * an integer value or compared against 0.0 to obtain a boolean 
     * (0.0 is treated as false, any other value would be true).
     */
    public void setValue(Double val);

    /**
     * Set the value from a double. If necessary this may be truncated into
     * an integer value or compared against 0.0 to obtain a boolean 
     * (0.0 is treated as false, any other value would be true).
     */
    public void setValue(double val); 

    /**
     * Set the value from an Integer. If necessary this may be compared 
     * against 0 to obtain a boolean (0 is treated as false, any other value 
     * would be true).
     */
    public void setValue(Integer val); 

    /**
     * Set the value from an int. If necessary this may be compared 
     * against 0 to obtain a boolean (0 is treated as false, any other value 
     * would be true).
     */
    public void setValue(int val); 

    /**
     * Set the value from a Boolean. If the actual value is an integer or
     * double value it will be set to 0 or 0.0 if this value is false, and
     * set to 1 or 1.0 if the value is true.
     */
    public void setValue(Boolean val); 

    /**
     * Set the value from a boolean. If the actual value is an integer or
     * double value it will be set to 0 or 0.0 if this value is false, and
     * set to 1 or 1.0 if the value is true.
     */
    public void setValue(boolean val); 

    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */

    /**
     * Get the value.  The actual return type will depend on the actual
     * class, but typically would be a Double, Integer, Boolean, or String.
     */
    public Object getValue();

    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
}
