package KTEditor;

import java.io.Serializable;
import java.awt.*;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

/**
 *
 * xx more later
 * <p>
 * 
 * @author  Scott Hudson
 */
public class SegmentDescriptor implements TagArtist, Serializable {
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    /* instance variables */
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */

    /** 
     * Object representing the conflict group that this segment belongs to.  
     * Segments conflict when they refer to the same conflict group object 
     * (or all are set to null) and do not otherwise.  
     */
    protected Object conflictGroup = null;

    /** 
     * Return the object representing the conflict group that this segment 
     * belongs to. Segments conflict when they refer to the same conflict 
     * group object (or all are set to null) and do not otherwise.  
     */
    public Object getConflictGroup() {return conflictGroup;}

    /** 
     * Set the object representing the conflict group that this segment 
     * belongs to. Segments conflict when they refer to the same conflict 
     * group object (or all are set to null) and do not otherwise.  
     */
    public void setConflictGroup(Object grp) {conflictGroup = grp;}
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */    
    /** 
     * Name of this segment.  This should be something short, but suitable 
     * for display to the user 
     */
    protected String name = "$$Default$$";

    /** Return the name of the segment. */
    public String getName() {return name;}

    /** Set the name of the segment. */
    public void setName(String nm) {name = nm;}
    
   /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */    

   /**
    * Color for portraying this segment.
    */
   protected Color segmentColor = null;

   /**
    * Get the color for portraying this segment.
    */
   public Color getSegmentColor() {return segmentColor;}

   /**
    * Set the color for portraying this segment.
    */
   public void setSegmentColor(Color clr) {segmentColor = clr;}
   
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
   
    /** 
     * The artist object that does drawing for us.  To get default drawing 
     * this can be set to null.
     */
    protected TagArtist artist = null;
     
    /** 
     * Get the artist object that does drawing for us. If this is null the
     * object itself is the artist and provides a default behavior.
     */
    public  TagArtist getArtist() {return artist;}
        
    /** 
     * Set the artist object that does drawing for us.  To get default drawing 
     * this can be set to null.
     */
    public  void setArtist(TagArtist art) { artist = art; }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    /* methods */
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /**
     * Test whether this segment conflicts (hence is not allowed to overlap) 
     * with another segment.  By default a segment conflicts with other 
     * segments sharing the same conflictGroup object.
     */
    public boolean conflictsWith(SegmentDescriptor other)
    {
        return other.getConflictGroup() == getConflictGroup();
    }

    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /**
     * String conversion.  Here we give the name, and conflict group. 
     */
    public String toString()
    {
        return getName() + "(" + ((getConflictGroup()==null)?"":getConflictGroup()) + ")";
    }
          
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */   
    
    /** 
     * Utility routine to return a highlight rectangle going down to the
     * given baseline instead of all the way down to bottom of the descenders.
     */
    public static Rectangle baselineRect(Rectangle fromFullRect, int baselineOff)
    {
        return new Rectangle((int)fromFullRect.getX(), (int)fromFullRect.getY(), 
                             (int)fromFullRect.getWidth(), baselineOff);
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /**
     * Default drawing for a rectangle with a highlight color/pattern denoting the tag.  
     * This is to be used under the text drawing.  The drawing should be limited to the 
     * given rectangle and is intending to cover the given positions within the document 
     * being edited by the given text pane.<p>
     *
     * Currently we do a simple colored area fill using the color of the segment.
     */
    public void defaultDrawHighlightRect(
        Graphics g, 
        Rectangle drawRect, 
        int baselineOff,
        JTextComponent inComponent, 
        int startPos, int endPos, 
        View forView, 
        Shape viewBounds,
        int ends) 
    {
        // set the color and fill the rectangle
        g.setColor(getSegmentColor());
        g.fillRect(drawRect.x,drawRect.y, drawRect.width,drawRect.height);
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /**
     * Default drawing for drawing a rectangle with a color/pattern used as part 
     * of the appearance of an item (such as a button or menu item) used to select the tag.<p>
     *
     * Currently we do a simple colored area fill using the color of the segment.
     */
    public void defaultDrawSelectorRect(Graphics g, Rectangle drawRect) 
    {
        // set the color and fill the rectangle
        g.setColor(getSegmentColor());
        g.fillRect(drawRect.x,drawRect.y, drawRect.width,drawRect.height);
    } 
        
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /**
     * Default drawing for the tag name at the start of a tag.
     *
     * Here we draw nothing.
     */
    public void defaultDrawStartText(Graphics g, String text, Rectangle drawRect, int baselineOff) 
    {
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /**
     * Default drawing for text at the end of a tag.
     *
     * Here we draw nothing.
     */
    public void defaultDrawEndText(Graphics g, String text, Rectangle drawRect, int baselineOff) 
    {
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /**
     * Draw a rectangle with a highlight color/pattern denoting the tag.  This is to be used
     * under the text drawing.  The drawing should be limited to the given rectangle and is
     * intending to cover the given positions within the document being edited by the given
     * text component.  Drawing is being done for the given view which has the given bounds.  The
     * parameter ends indicates whether the highlight includes the left and/or right end of
     * the overall highlight (by the bits TagArtist.LEFT_END and/or TagArtist.RIGHT_END being
     * set).
     */
    public void drawHighlightRect(
        Graphics g, 
        Rectangle drawRect, 
        int baselineOff,
        JTextComponent inComponent, 
        int startPos, 
        int endPos, 
        View forView, 
        Shape viewBounds, 
        int ends) 
    {
        // if we don't have an artist (or we're the artist) use the default
        if (getArtist() == null || getArtist() == this) 
            defaultDrawHighlightRect(g,drawRect,baselineOff,inComponent,startPos,endPos,forView,viewBounds,ends);
        else
            // use the artist
            getArtist().drawHighlightRect(g,drawRect,baselineOff,inComponent,startPos,endPos,forView,viewBounds,ends);
    }
        
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /**
     * Fill a rectangle with a color/pattern used as part of the appearance of an item
     * (such as a button or menu item) used to select the tag.
     */
    public void drawSelectorRect(Graphics g, Rectangle drawRect) 
    { 
        // if we don't have an artist (or we're the artist) use the default
        if (getArtist() == null || getArtist() == this) 
            defaultDrawSelectorRect(g,drawRect);
        else
            // use the artist
            getArtist().drawSelectorRect(g,drawRect);
    }
    
    /**
     * Draw a text tag at the start of a tag highlight.  The given rectangle
     * runs from the start of the tag to either the end of the tag or the
     * end of the line that the start was on. Drawing should stay
     * within that rectangle.
     */
    public void drawStartText(Graphics g, String text, Rectangle drawRect, int baselineOff) {
        // if we don't have an artist (or we're the artist) use the default
        if (getArtist() == null || getArtist() == this) 
            defaultDrawStartText(g,text,drawRect,baselineOff);
        else
            // use the artist
            getArtist().drawStartText(g,text,drawRect,baselineOff);
    }
    
    /** Draw a text tag at the end of a tag highlight.  The given rectangle
     * runs from either the start of the tag, or the start of the line that
     * the tag ends on, and goes to the end of the tag.  Drawing should stay
     * within that rectangle.
     */
    public void drawEndText(Graphics g, String text, Rectangle drawRect, int baselineOff) {
        // if we don't have an artist (or we're the artist) use the default
        if (getArtist() == null || getArtist() == this) 
            defaultDrawEndText(g,text,drawRect,baselineOff);
        else
            // use the artist
            getArtist().drawEndText(g,text,drawRect,baselineOff);
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    /* constructors */
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */

    /** 
     * Construct a descriptor for a segment using full information.
     */
    public SegmentDescriptor(String nm, Color clr, TagArtist tArtist, Object conflGrp) 
      {setName(nm); setSegmentColor(clr); setConflictGroup(conflGrp); setArtist(tArtist);}
  
    /** 
     * Construct a descriptor using the default for the artist.
     */
    public SegmentDescriptor(String nm, Color clr, Object conflGrp) 
      {this(nm,clr,null,conflGrp);}
  
    /** 
     * Construct a descriptor for a segment using the default (null) conflict
     * group.
     */
    public SegmentDescriptor(String nm, Color clr) {this(nm,clr, null);}
    
     /** 
     * Construct a descriptor for a segment using the default (null) conflict
     * group.
     */
    public SegmentDescriptor(String nm) {this(nm,new Color(0.5f,0.5f,0.5f,0.5f), null);}
    
    /** 
     * Construct a descriptor for segment all defaults.  To be useful, this
     * segment needs to at least be given a name.
     */
    public SegmentDescriptor() {this("$$Default$$", new Color(0.5f,0.5f,0.5f,0.5f), null);}
   
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
}
