package KTEditor;

import java.io.Serializable;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

/** 
 * The set of drawing operations necessary to support the display of a 
 * tag or effect.
 */
public interface TagArtist extends Serializable {
        /** Bit mask value to indicate that drawing includes the left end of a tag highlight */
        public final int LEFT_END = 1;
        /** Bit mask value to indicate that drawing includes the right end of a tag highlight */
        public final int RIGHT_END = 2;
        
        /** 
         * Draw a rectangle with a highlight color/pattern denoting the tag.  This is to be used
         * under the text drawing.  The given rectangle covers the text (whose baseline offset is given from
         * the top of that rectangle) for the given positions within the document being edited by the given
         * text component.  Drawing is being done for the given view which has the given bounds.  The 
         * parameter ends indicates whether the highlight includes the left and/or right end of 
         * the overall highlight (by the bits TagArtist.LEFT_END and/or TagArtist.RIGHT_END being
         * set).
         */
	public void drawHighlightRect(
          Graphics g, 
          Rectangle drawRect, 
          int baselineOff,
          JTextComponent inComponent, 
          int startPos, 
          int endPos,
          View forView,
          Shape viewBounds,
          int endsCode);
        
        /** 
         * Fill a rectangle with a color/pattern used as part of the appearance of an item
         * (such as a button or menu item) used to select the tag.
         */
        public void drawSelectorRect(Graphics g, Rectangle drawRect);
        
        /** 
         * Draw a text tag at the start of a tag highlight.  The given rectangle 
         * runs from the start of the tag to either the end of the tag or the 
         * end of the line that the start was on.  The baseline of the text this applies to
         * is also given.
         */
        public void drawStartText(Graphics g, String text, Rectangle drawRect, int baselineOff);
        
        /**
         * Draw a text tag at the end of a tag highlight.  The given rectangle 
         * runs from either the start of the tag, or the start of the line that 
         * the tag ends on, and goes to the end of the tag.  The baseline of the 
         * text this applies to is also given.
         */
        public void drawEndText(Graphics g, String text, Rectangle drawRect, int baselineOff);
}

