/*
 * KT_Test.java
 *
 * Created on September 12, 2002, 11:26 PM
 */

package KT_Test;
import kinetic.*;
import kinetic.util.*;
import kinetic.util.MovieEncoder.*;
import java.awt.*;
import java.io.*;
import javax.swing.*;
import javax.swing.filechooser.FileFilter;
import java.awt.event.*;
/**
 *
 * @author  Johnny Lee
 */
public class KT_Test extends javax.swing.JFrame implements KTEngineEventListener,SequenceExportEventListener{
        
    //modify these two to adjust rendering quality
    // 0 = no motion blur
    // 30 = 30 x temporal super sampling (30 renders per frame)
    protected int previewMotionBlur = 0;  //real time
    protected int exportMotionBlur = 16; //quicktime export
    protected boolean antialiasing = true;
    protected float exportQuality = 0.8f; //QT compression quality 1.0 = lossless

    protected double previewShutterAngle = 180; //real time
    protected double exportShutterAngle = 180; //quicktime export
    protected double keyIncrement = 5;
    public KTEngine engine;

    public class KeyListener implements ActionListener{
        KT_Test app;
        public KeyListener(KT_Test a){
            app = a;
        }
        public void actionPerformed(ActionEvent e){
            if(e.getActionCommand().equals("37")){
                double t = app.engine.getLastTime();
                if(t >= keyIncrement)
                    t -= keyIncrement;
                else
                    t = 0;
                app.engine.draw(t);
                app.updateUI(t);
            }
            if(e.getActionCommand().equals("39")){
                double t = app.engine.getLastTime();
                if(t <= app.engine.getSequence().getDuration()-keyIncrement)
                    t += keyIncrement;
                else
                    t = app.engine.getSequence().getDuration();
                app.engine.draw(t);
                app.updateUI(t);
            }
            if(e.getActionCommand().equals("10")){
                app.playButtonPressed(null);
            }
        }
        public void addComponent(JComponent c){
          for(int i = 0; i < 255; i++){
            c.registerKeyboardAction(   this,
                                        "" + i,
                                        KeyStroke.getKeyStroke(i,0,false),
                                        javax.swing.JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
            c.registerKeyboardAction(   this,
                                        "-" + i,
                                        KeyStroke.getKeyStroke(i,0,true),
                                        javax.swing.JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
          }
        }
    }
    
    public KeyListener kl;
    
    /** Creates new form KT_Test */
    public KT_Test() {
        initComponents();
//        time.setVisible(false);
        kl = new KeyListener(this);
        engine = new KTEngine();
        engine.antialiasing = antialiasing;
        engine.setStage(canvas);
        engine.setKTEngineEventListener(this);
        engine.setMotionBlur(previewMotionBlur,previewShutterAngle,0.0);
        kl.addComponent(jPanel1);
        
        demos.addItem("---");
        demos.addItem("Test");
        demos.addItem("Demos");
        demos.addItem("Oh Boy");
        demos.addItem("Oh Nice");
        demos.addItem("Monty Python");
        demos.addItem("Oscillate");
        demos.addItem("Move");
        demos.addItem("Hop");
        demos.addItem("HopIn");
        }    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenu1 = new javax.swing.JMenu();
        canvas = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        Export = new javax.swing.JButton();
        timeSlider = new javax.swing.JSlider();
        time = new javax.swing.JLabel();
        rewind = new javax.swing.JButton();
        play = new javax.swing.JButton();
        demos = new javax.swing.JComboBox();

        jMenu1.setText("Menu");
        jMenuBar1.add(jMenu1);

        getContentPane().setLayout(new java.awt.FlowLayout());

        setTitle("KT Test");
        try{
            //encoder = new QTEncoder(this, test,640,480,2.0,30.0);
        }
        catch(Exception x){
            System.err.println(x);
        }
        addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                onKeyDown(evt);
            }
        });

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        canvas.setBackground(new java.awt.Color(255, 255, 255));
        canvas.setMaximumSize(new java.awt.Dimension(640, 480));
        canvas.setMinimumSize(new java.awt.Dimension(640, 360));
        canvas.setPreferredSize(new java.awt.Dimension(640, 480));
        getContentPane().add(canvas);

        Export.setText("Export");
        Export.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exportButtonPressed(evt);
            }
        });

        jPanel1.add(Export);

        timeSlider.setMaximum(100000);
        timeSlider.setValue(0);
        timeSlider.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                timesliderKepPressed(evt);
            }
        });

        timeSlider.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                sliderDragged(evt);
            }
        });

        jPanel1.add(timeSlider);

        time.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        time.setText("0.0 ms");
        time.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        jPanel1.add(time);

        rewind.setText("Rew");
        rewind.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rewButtonPressed(evt);
            }
        });

        jPanel1.add(rewind);

        play.setText("Play");
        play.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                playButtonPressed(evt);
            }
        });

        jPanel1.add(play);

        demos.setMinimumSize(new java.awt.Dimension(100, 25));
        demos.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                demosActionPerformed(evt);
            }
        });

        jPanel1.add(demos);

        getContentPane().add(jPanel1);

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(673, 559));
        setLocation((screenSize.width-673)/2,(screenSize.height-559)/2);
    }//GEN-END:initComponents

    private void demosActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_demosActionPerformed
        // Add your handling code here:
        String demo = demos.getSelectedItem().toString();
        engine.getSequence().clear();
        if(demo.compareTo("Demos") == 0){
            System.out.println("build demos");
            engine.setSequenceBuilder(new EarlyDemos());
            engine.buildAnimation();
        }
        if(demo.compareTo("Monty Python") == 0){
            System.out.println("build monty python");
            engine.setSequenceBuilder(new MontyPythonDemo());
            engine.buildAnimation();
        }
        if(demo.compareTo("Oscillate") == 0){
            System.out.println("build oscillate");
            engine.setSequenceBuilder(new OscillateDemo());
            engine.buildAnimation();
        }
        if(demo.compareTo("Oh Nice") == 0){
            System.out.println("build oh no");
            engine.setSequenceBuilder(new NoNoNoDemo());
            engine.buildAnimation();
        }
        if(demo.compareTo("Oh Boy") == 0){
            System.out.println("build oh boy");
            engine.setSequenceBuilder(new OhBoyDemo());
            engine.buildAnimation();
        }

        
        if(demo.compareTo("Move") == 0){
            System.out.println("build move demo");
            engine.setSequenceBuilder(new MoveDemo());
            engine.buildAnimation();
        }
        if(demo.compareTo("Hop") == 0){
            System.out.println("build hop demos");
            engine.setSequenceBuilder(new HopDemo());
            engine.buildAnimation();
        }
        if(demo.compareTo("HopIn") == 0){
            System.out.println("build hop in demo");
            engine.setSequenceBuilder(new HopInDemo());
            engine.buildAnimation();
        }
        if(demo.compareTo("Test") == 0){
            System.out.println("build test");
            engine.setSequenceBuilder(new ImageTest());
            engine.buildAnimation();
        }

        //experimental and under development
//        KTML_Manager ktml = new KTML_Manager();
//        ktml.generateKTML(engine.getSequence());

        engine.resetAnimationTime();
        updateUI(0.0);
    }//GEN-LAST:event_demosActionPerformed

    private void timesliderKepPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_timesliderKepPressed
        // Add your handling code here:
        
        if(evt.getKeyCode() == 37){
            double t = engine.getLastTime();
            if(t >= keyIncrement)
                t -= keyIncrement;
            else
                t = 0;
            engine.draw(t);
            updateUI(t);
        }
        if(evt.getKeyCode() == 39){
            double t = engine.getLastTime();
            if(t <= engine.getSequence().getDuration()-keyIncrement)
                t += keyIncrement;
            else
                t = engine.getSequence().getDuration();
            engine.draw(t);
            updateUI(t);
        }
    }//GEN-LAST:event_timesliderKepPressed

    private void onKeyDown(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_onKeyDown
        // Add your handling code here:
        System.out.println("Key down");
    }//GEN-LAST:event_onKeyDown

    private void sliderDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_sliderDragged
        // Add your handling code here:
        double value = timeSlider.getValue();
        double max = timeSlider.getMaximum();
        double dur = engine.getSequence().getDuration();
        double t = (value/max)*dur;
        engine.setAnimationTime(t);
        engine.draw(t);
        int v = (int)t;
        this.time.setText(String.valueOf(v) + " ms");        
    }//GEN-LAST:event_sliderDragged

    public class dotMovFilter extends FileFilter {
        public boolean accept(File f) {
            return f!= null && f.getName().endsWith(".mov");
        }
        public String getDescription() {
            return "QuickTime movie files (*.mov)";
        }
    }
    public boolean overwriteGuard(File wFile) {
        // if the file doesn't already exist we are fine
        if (!wFile.exists()) return true;
        
        // put up an overwite confirm dialog
        int userSays = JOptionPane.showConfirmDialog(this,
        wFile.getName() + " already exists. Replace it?", "Replace?",
        JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
        
        // we are clean if and only if they press yes
        return (userSays == JOptionPane.YES_OPTION);
    }
    
    
    private void exportButtonPressed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exportButtonPressed
        // Add your handling code here:
        File oFile = null;
        FileFilter movFilter = new dotMovFilter();
        try {
            JFileChooser exportFilePicker = new JFileChooser();
            exportFilePicker.addChoosableFileFilter(movFilter);
            
            // always filter to .mov by default
            exportFilePicker.setFileFilter(movFilter);
            
            // run the file dialog
            int returnV = exportFilePicker.showSaveDialog(this);
            
            // do we proceed?
            if (returnV == JFileChooser.APPROVE_OPTION) {
                // get the file they selected
                oFile = exportFilePicker.getSelectedFile();
                
                // file name must end in .mov
                if (!oFile.getName().endsWith(".mov")) {
                    // force a .mov at the end
                    oFile = new File(oFile.getPath()+".mov");
                }
                
                // if it exists already confirm overwrite
                if (overwriteGuard(oFile)) {
                    // make sure we have a frame to watch the export in                    
                    // make sure a sequence is installed in the previewer
                    
                        Sequence seq = engine.getSequence();
                    
                    // get the sequence duration, change default to 0, and compute seconds
                    long seqDur = (long)seq.getDuration();
                    if (seqDur == Long.MAX_VALUE) seqDur = 0;
                    int durSec = (int)Math.ceil(seqDur/1000.0);
                    
                    float fps = 30.0f; //xx later let the user pick
                    
                    // export the sequence

                    SequenceExporter exporter =
                    new SequenceExporter(canvas, seq, durSec, fps);
                    exporter.setMotionBlur(exportMotionBlur,exportShutterAngle,0.0);
                    exporter.setEventListener(this);
                    double startTime = System.currentTimeMillis();
                    exporter.export("file:" + oFile.getPath(), exportQuality);
                    double endTime = System.currentTimeMillis();
                    System.err.println("Time Taken to render movie: " + (endTime-startTime)/1000.0 + " secs");
                }
            }
        } catch (Exception e) {
            // xx fix this later to deal with more specific exceptions
            //xx extra debug for us for now
            e.printStackTrace();
            
            // tell the user
            JOptionPane.showMessageDialog(this, "\"" +
            ((oFile==null)?"File":oFile.getName()) +
            "\" could not be exported. (" + e +")",
            "Export Failed", JOptionPane.WARNING_MESSAGE);
        }
    }//GEN-LAST:event_exportButtonPressed

    private void playButtonPressed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_playButtonPressed
        // Add your handling code here:
        if(engine.getLastTime() >= engine.getSequence().getDuration()-100)
            engine.resetAnimationTime();
        if(engine.isRunning()){
            engine.stop();
        }else{
            engine.start();
        }
    }//GEN-LAST:event_playButtonPressed

    private void rewButtonPressed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rewButtonPressed
        // Add your handling code here:
        engine.resetAnimationTime();
        updateUI(0.0);
    }//GEN-LAST:event_rewButtonPressed
    
    /** Exit the Application
     * @param evt window closing event
     */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit(0);
    }//GEN-LAST:event_exitForm
    
    /** main routine
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new KT_Test().show();
    }
    
    public void onAnimationNewFrame(double time) {
        updateUI(time);
    }    
    
    public void updateUI(double t){
        int v = (int)t;
        int pos = (int)(timeSlider.getMaximum()*(t/engine.getSequence().getDuration()));
        this.time.setText(String.valueOf(v) + " ms");
        timeSlider.setValue(pos);        
    }
    public void onAnimationStart(double time) {
        play.setText("Pause");
    }
    
    public void onAnimationStop(double time) {
        play.setText("Play");
    }
    public void onExportBegin() {
        System.err.println("Beginning Export");
    }
    
    public void onExportFinish() {
        System.err.println("Export Complete");
    }
    
    public void onExportNewFrame(double time) {
        updateUI(time);
        update(getGraphics());
    }
    
    public void onAnimationFinished(double time) {
        //advance animation and reset time.
        /*
        int item = demos.getSelectedIndex();
        if (item+1 < demos.getItemCount())
            demos.setSelectedIndex(item+1);
        engine.resetAnimationTime();
        updateUI(0.0);*/
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel canvas;
    private javax.swing.JLabel time;
    private javax.swing.JComboBox demos;
    private javax.swing.JButton play;
    private javax.swing.JButton rewind;
    private javax.swing.JSlider timeSlider;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JButton Export;
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenuBar jMenuBar1;
    // End of variables declaration//GEN-END:variables
    
}
