/*
 * KTEngineEventListener.java
 *
 * Created on August 30, 2002, 12:27 PM
 *
 * * Kinetic Typography Engine - java library for animating expressive text
 * Copyright (C) 2002 Johnny Chung Lee 
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 */

package kinetic.util;

/** interface used if you want be able to respond to even generated by the engine such as animation start, stop, finish, and new frame requests to update something like a UI
 * @author Johnny Lee
 */
public interface KTEngineEventListener{

    /** called when the animation is started
     * @param time value of the animation time when called
     */    
    public void onAnimationStart(double time);
    /** called when the animation was stopped
     * @param time value of the animation time when called
     */    
    public void onAnimationStop(double time);
    /** called when the engine reached the end of the aniamtion sequence
     * @param time value of the animation time when called
     */    
    public void onAnimationFinished(double time);
    /** call when the engine requests a new frame to be drawn
     * @param time value of the animation time when called
     */    
    public void onAnimationNewFrame(double time);
}
