//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Runtime Version:2.0.50727.312
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

using Microsoft.Ccr.Core;
using Microsoft.Dss.Core.Attributes;
using Microsoft.Dss.ServiceModel.Dssp;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Xml.Serialization;
using W3C.Soap;
using compression = System.IO.Compression;
using constructor = Microsoft.Dss.Services.Constructor;
using contractmodel = Microsoft.Dss.Services.ContractModel;
using io = System.IO;
using reflection = System.Reflection;
using wiimotelib = WiimoteLib.Proxy;


namespace WiimoteLib.Proxy
{
    
    /// <summary>
    /// Wiimote Contract
    /// </summary>
    [XmlTypeAttribute(IncludeInSchema=false)]
    public sealed class Contract
    {
        /// The Unique Contract Identifier for the Wiimote service
        public const String Identifier = "http://schemas.tempuri.org/2007/06/wiimote.html";
        /// The Dss Service dssModel Contract(s)
        public static List<contractmodel.ServiceSummary> ServiceModel()
        {
            List<contractmodel.ServiceSummary> services = null;
            io.Stream stream = null;
            try
            {
                string Resource = @"WiimoteLib.Resources.DssModel.dss";
                stream = reflection.Assembly.GetExecutingAssembly().GetManifestResourceStream(Resource);
                compression.GZipStream compressionStream = new compression.GZipStream(stream, compression.CompressionMode.Decompress, true);
                XmlSerializer serializer = new XmlSerializer(typeof(List<contractmodel.ServiceSummary>));
                services = (List<contractmodel.ServiceSummary>)serializer.Deserialize(compressionStream);
                compressionStream.Close();
            }
            catch (Exception ex)
            {
                Console.WriteLine("Error retrieving Dss Service Model: ", ex.Message);
            }
            finally
            {
                if (stream != null)
                {
                    stream.Close();
                    stream = null;
                }
            }
            return services;

        }
        /// <summary>
        /// Creates an instance of the service associated with this contract
        /// </summary>
        /// <param name="contructorServicePort">Contractor Service that will create the instance</param>
        /// <param name="partners">Optional list of service partners for new service instance</param>
        /// <returns>Result PortSet for retrieving service creation response</returns>
        public static DsspResponsePort<CreateResponse> CreateService(constructor.ConstructorPort contructorServicePort, params PartnerType[] partners)
        {
            DsspResponsePort<CreateResponse> result = new DsspResponsePort<CreateResponse>();
            ServiceInfoType si = new ServiceInfoType(Contract.Identifier, null);
            if (partners != null)
            {
                si.PartnerList = new List<PartnerType>(partners);
            }
            Microsoft.Dss.Services.Constructor.Create create =
                new Microsoft.Dss.Services.Constructor.Create(si, result);
            contructorServicePort.Post(create);
            return result;

        }
        /// <summary>
        /// Creates an instance of the service associated with this contract
        /// </summary>
        /// <param name="contructorServicePort">Contractor Service that will create the instance</param>
        /// <returns>Result PortSet for retrieving service creation response</returns>
        public static DsspResponsePort<CreateResponse> CreateService(constructor.ConstructorPort contructorServicePort)
        {
            return Contract.CreateService(contructorServicePort, null);
        }
    }
    /// <summary>
    /// Wiimote State
    /// </summary>
    [DataContract()]
    [XmlRootAttribute("WiimoteState", Namespace="http://schemas.tempuri.org/2007/06/wiimote.html")]
    public class WiimoteState : System.ICloneable
    {
        private CalibrationInfo _calibrationInfo;
        private ButtonState _buttonState;
        private AccelState _accelState;
        private IRState _iRState;
        private Byte _battery;
        private Boolean _rumble;
        private Boolean _extension;
        private ExtensionType _extensionType;
        private NunchukState _nunchukState;
        private ClassicControllerState _classicControllerState;
        private LEDs _lEDs;
        /// <summary>
        /// Calibration Info
        /// </summary>
        [DataMember()]
        public CalibrationInfo CalibrationInfo
        {
            get
            {
                return this._calibrationInfo;
            }
            set
            {
                this._calibrationInfo = value;
            }
        }
        /// <summary>
        /// Button State
        /// </summary>
        [DataMember()]
        public ButtonState ButtonState
        {
            get
            {
                return this._buttonState;
            }
            set
            {
                this._buttonState = value;
            }
        }
        /// <summary>
        /// Accel State
        /// </summary>
        [DataMember()]
        public AccelState AccelState
        {
            get
            {
                return this._accelState;
            }
            set
            {
                this._accelState = value;
            }
        }
        /// <summary>
        /// IR State
        /// </summary>
        [DataMember()]
        public IRState IRState
        {
            get
            {
                return this._iRState;
            }
            set
            {
                this._iRState = value;
            }
        }
        /// <summary>
        /// Battery
        /// </summary>
        [DataMember()]
        public Byte Battery
        {
            get
            {
                return this._battery;
            }
            set
            {
                this._battery = value;
            }
        }
        /// <summary>
        /// Rumble
        /// </summary>
        [DataMember()]
        public Boolean Rumble
        {
            get
            {
                return this._rumble;
            }
            set
            {
                this._rumble = value;
            }
        }
        /// <summary>
        /// Extension
        /// </summary>
        [DataMember()]
        public Boolean Extension
        {
            get
            {
                return this._extension;
            }
            set
            {
                this._extension = value;
            }
        }
        /// <summary>
        /// Extension Type
        /// </summary>
        [DataMember()]
        public ExtensionType ExtensionType
        {
            get
            {
                return this._extensionType;
            }
            set
            {
                this._extensionType = value;
            }
        }
        /// <summary>
        /// Nunchuk State
        /// </summary>
        [DataMember()]
        public NunchukState NunchukState
        {
            get
            {
                return this._nunchukState;
            }
            set
            {
                this._nunchukState = value;
            }
        }
        /// <summary>
        /// Classic Controller State
        /// </summary>
        [DataMember()]
        public ClassicControllerState ClassicControllerState
        {
            get
            {
                return this._classicControllerState;
            }
            set
            {
                this._classicControllerState = value;
            }
        }
        /// <summary>
        /// LE Ds
        /// </summary>
        [DataMember()]
        public LEDs LEDs
        {
            get
            {
                return this._lEDs;
            }
            set
            {
                this._lEDs = value;
            }
        }
        public void CopyTo(WiimoteState target)
        {
            target.CalibrationInfo = this.CalibrationInfo;
            target.ButtonState = this.ButtonState;
            target.AccelState = this.AccelState;
            target.IRState = this.IRState;
            target.Battery = this.Battery;
            target.Rumble = this.Rumble;
            target.Extension = this.Extension;
            target.ExtensionType = this.ExtensionType;
            target.NunchukState = this.NunchukState;
            target.ClassicControllerState = this.ClassicControllerState;
            target.LEDs = this.LEDs;
        }
        public virtual object Clone()
        {
            WiimoteState target = new WiimoteState();

            target.CalibrationInfo = this.CalibrationInfo;
            target.ButtonState = this.ButtonState;
            target.AccelState = this.AccelState;
            target.IRState = this.IRState;
            target.Battery = this.Battery;
            target.Rumble = this.Rumble;
            target.Extension = this.Extension;
            target.ExtensionType = this.ExtensionType;
            target.NunchukState = this.NunchukState;
            target.ClassicControllerState = this.ClassicControllerState;
            target.LEDs = this.LEDs;
            return target;

        }
    }
    /// <summary>
    /// LE Ds
    /// </summary>
    [DataContract()]
    [XmlRootAttribute("LEDs", Namespace="http://schemas.tempuri.org/2007/06/wiimote.html")]
    public struct LEDs : System.ICloneable
    {
        private Boolean _lED1;
        private Boolean _lED2;
        private Boolean _lED3;
        private Boolean _lED4;
        /// <summary>
        /// LED1
        /// </summary>
        [DataMember()]
        public Boolean LED1
        {
            get
            {
                return this._lED1;
            }
            set
            {
                this._lED1 = value;
            }
        }
        /// <summary>
        /// LED2
        /// </summary>
        [DataMember()]
        public Boolean LED2
        {
            get
            {
                return this._lED2;
            }
            set
            {
                this._lED2 = value;
            }
        }
        /// <summary>
        /// LED3
        /// </summary>
        [DataMember()]
        public Boolean LED3
        {
            get
            {
                return this._lED3;
            }
            set
            {
                this._lED3 = value;
            }
        }
        /// <summary>
        /// LED4
        /// </summary>
        [DataMember()]
        public Boolean LED4
        {
            get
            {
                return this._lED4;
            }
            set
            {
                this._lED4 = value;
            }
        }
        public void CopyTo(ref LEDs target)
        {
            target.LED1 = this.LED1;
            target.LED2 = this.LED2;
            target.LED3 = this.LED3;
            target.LED4 = this.LED4;
        }
        public object Clone()
        {
            LEDs target = new LEDs();

            target.LED1 = this.LED1;
            target.LED2 = this.LED2;
            target.LED3 = this.LED3;
            target.LED4 = this.LED4;
            return target;

        }
    }
    /// <summary>
    /// Rumble Request
    /// </summary>
    [DataContract()]
    [XmlRootAttribute("RumbleRequest", Namespace="http://schemas.tempuri.org/2007/06/wiimote.html")]
    public struct RumbleRequest : System.ICloneable
    {
        private Boolean _rumble;
        /// <summary>
        /// Rumble
        /// </summary>
        [DataMember()]
        public Boolean Rumble
        {
            get
            {
                return this._rumble;
            }
            set
            {
                this._rumble = value;
            }
        }
        public void CopyTo(ref RumbleRequest target)
        {
            target.Rumble = this.Rumble;
        }
        public object Clone()
        {
            RumbleRequest target = new RumbleRequest();

            target.Rumble = this.Rumble;
            return target;

        }
    }
    /// <summary>
    /// Extension Type
    /// </summary>
    [DataContract()]
    [XmlRootAttribute("ExtensionType", Namespace="http://schemas.tempuri.org/2007/06/wiimote.html")]
    public enum ExtensionType
    {
        /// <summary>
        /// None
        /// </summary>
        None = 0,
        /// <summary>
        /// Nunchuk
        /// </summary>
        Nunchuk = 254,
        /// <summary>
        /// Classic Controller
        /// </summary>
        ClassicController = 253,
    }
    /// <summary>
    /// Calibration Info
    /// </summary>
    [DataContract()]
    [XmlRootAttribute("CalibrationInfo", Namespace="http://schemas.tempuri.org/2007/06/wiimote.html")]
    public struct CalibrationInfo : System.ICloneable
    {
        private Byte _x0;
        private Byte _y0;
        private Byte _z0;
        private Byte _xG;
        private Byte _yG;
        private Byte _zG;
        /// <summary>
        /// X0
        /// </summary>
        [DataMember()]
        public Byte X0
        {
            get
            {
                return this._x0;
            }
            set
            {
                this._x0 = value;
            }
        }
        /// <summary>
        /// Y0
        /// </summary>
        [DataMember()]
        public Byte Y0
        {
            get
            {
                return this._y0;
            }
            set
            {
                this._y0 = value;
            }
        }
        /// <summary>
        /// Z0
        /// </summary>
        [DataMember()]
        public Byte Z0
        {
            get
            {
                return this._z0;
            }
            set
            {
                this._z0 = value;
            }
        }
        /// <summary>
        /// XG
        /// </summary>
        [DataMember()]
        public Byte XG
        {
            get
            {
                return this._xG;
            }
            set
            {
                this._xG = value;
            }
        }
        /// <summary>
        /// YG
        /// </summary>
        [DataMember()]
        public Byte YG
        {
            get
            {
                return this._yG;
            }
            set
            {
                this._yG = value;
            }
        }
        /// <summary>
        /// ZG
        /// </summary>
        [DataMember()]
        public Byte ZG
        {
            get
            {
                return this._zG;
            }
            set
            {
                this._zG = value;
            }
        }
        public void CopyTo(ref CalibrationInfo target)
        {
            target.X0 = this.X0;
            target.Y0 = this.Y0;
            target.Z0 = this.Z0;
            target.XG = this.XG;
            target.YG = this.YG;
            target.ZG = this.ZG;
        }
        public object Clone()
        {
            CalibrationInfo target = new CalibrationInfo();

            target.X0 = this.X0;
            target.Y0 = this.Y0;
            target.Z0 = this.Z0;
            target.XG = this.XG;
            target.YG = this.YG;
            target.ZG = this.ZG;
            return target;

        }
    }
    /// <summary>
    /// Button State
    /// </summary>
    [DataContract()]
    [XmlRootAttribute("ButtonState", Namespace="http://schemas.tempuri.org/2007/06/wiimote.html")]
    public struct ButtonState : System.ICloneable
    {
        private Boolean _a;
        private Boolean _b;
        private Boolean _plus;
        private Boolean _home;
        private Boolean _minus;
        private Boolean _one;
        private Boolean _two;
        private Boolean _up;
        private Boolean _down;
        private Boolean _left;
        private Boolean _right;
        /// <summary>
        /// A
        /// </summary>
        [DataMember()]
        public Boolean A
        {
            get
            {
                return this._a;
            }
            set
            {
                this._a = value;
            }
        }
        /// <summary>
        /// B
        /// </summary>
        [DataMember()]
        public Boolean B
        {
            get
            {
                return this._b;
            }
            set
            {
                this._b = value;
            }
        }
        /// <summary>
        /// Plus
        /// </summary>
        [DataMember()]
        public Boolean Plus
        {
            get
            {
                return this._plus;
            }
            set
            {
                this._plus = value;
            }
        }
        /// <summary>
        /// Home
        /// </summary>
        [DataMember()]
        public Boolean Home
        {
            get
            {
                return this._home;
            }
            set
            {
                this._home = value;
            }
        }
        /// <summary>
        /// Minus
        /// </summary>
        [DataMember()]
        public Boolean Minus
        {
            get
            {
                return this._minus;
            }
            set
            {
                this._minus = value;
            }
        }
        /// <summary>
        /// One
        /// </summary>
        [DataMember()]
        public Boolean One
        {
            get
            {
                return this._one;
            }
            set
            {
                this._one = value;
            }
        }
        /// <summary>
        /// Two
        /// </summary>
        [DataMember()]
        public Boolean Two
        {
            get
            {
                return this._two;
            }
            set
            {
                this._two = value;
            }
        }
        /// <summary>
        /// Up
        /// </summary>
        [DataMember()]
        public Boolean Up
        {
            get
            {
                return this._up;
            }
            set
            {
                this._up = value;
            }
        }
        /// <summary>
        /// Down
        /// </summary>
        [DataMember()]
        public Boolean Down
        {
            get
            {
                return this._down;
            }
            set
            {
                this._down = value;
            }
        }
        /// <summary>
        /// Left
        /// </summary>
        [DataMember()]
        public Boolean Left
        {
            get
            {
                return this._left;
            }
            set
            {
                this._left = value;
            }
        }
        /// <summary>
        /// Right
        /// </summary>
        [DataMember()]
        public Boolean Right
        {
            get
            {
                return this._right;
            }
            set
            {
                this._right = value;
            }
        }
        public void CopyTo(ref ButtonState target)
        {
            target.A = this.A;
            target.B = this.B;
            target.Plus = this.Plus;
            target.Home = this.Home;
            target.Minus = this.Minus;
            target.One = this.One;
            target.Two = this.Two;
            target.Up = this.Up;
            target.Down = this.Down;
            target.Left = this.Left;
            target.Right = this.Right;
        }
        public object Clone()
        {
            ButtonState target = new ButtonState();

            target.A = this.A;
            target.B = this.B;
            target.Plus = this.Plus;
            target.Home = this.Home;
            target.Minus = this.Minus;
            target.One = this.One;
            target.Two = this.Two;
            target.Up = this.Up;
            target.Down = this.Down;
            target.Left = this.Left;
            target.Right = this.Right;
            return target;

        }
    }
    /// <summary>
    /// Accel State
    /// </summary>
    [DataContract()]
    [XmlRootAttribute("AccelState", Namespace="http://schemas.tempuri.org/2007/06/wiimote.html")]
    public struct AccelState : System.ICloneable
    {
        private Byte _rawX;
        private Byte _rawY;
        private Byte _rawZ;
        private Single _x;
        private Single _y;
        private Single _z;
        /// <summary>
        /// RawX
        /// </summary>
        [DataMember()]
        public Byte RawX
        {
            get
            {
                return this._rawX;
            }
            set
            {
                this._rawX = value;
            }
        }
        /// <summary>
        /// RawY
        /// </summary>
        [DataMember()]
        public Byte RawY
        {
            get
            {
                return this._rawY;
            }
            set
            {
                this._rawY = value;
            }
        }
        /// <summary>
        /// RawZ
        /// </summary>
        [DataMember()]
        public Byte RawZ
        {
            get
            {
                return this._rawZ;
            }
            set
            {
                this._rawZ = value;
            }
        }
        /// <summary>
        /// X
        /// </summary>
        [DataMember()]
        public Single X
        {
            get
            {
                return this._x;
            }
            set
            {
                this._x = value;
            }
        }
        /// <summary>
        /// Y
        /// </summary>
        [DataMember()]
        public Single Y
        {
            get
            {
                return this._y;
            }
            set
            {
                this._y = value;
            }
        }
        /// <summary>
        /// Z
        /// </summary>
        [DataMember()]
        public Single Z
        {
            get
            {
                return this._z;
            }
            set
            {
                this._z = value;
            }
        }
        public void CopyTo(ref AccelState target)
        {
            target.RawX = this.RawX;
            target.RawY = this.RawY;
            target.RawZ = this.RawZ;
            target.X = this.X;
            target.Y = this.Y;
            target.Z = this.Z;
        }
        public object Clone()
        {
            AccelState target = new AccelState();

            target.RawX = this.RawX;
            target.RawY = this.RawY;
            target.RawZ = this.RawZ;
            target.X = this.X;
            target.Y = this.Y;
            target.Z = this.Z;
            return target;

        }
    }
    /// <summary>
    /// IR State
    /// </summary>
    [DataContract()]
    [XmlRootAttribute("IRState", Namespace="http://schemas.tempuri.org/2007/06/wiimote.html")]
    public struct IRState : System.ICloneable
    {
        private IRMode _mode;
        private Int32 _rawX1;
        private Int32 _rawX2;
        private Int32 _rawY1;
        private Int32 _rawY2;
        private Int32 _size1;
        private Int32 _size2;
        private Boolean _found1;
        private Boolean _found2;
        private Single _x1;
        private Single _x2;
        private Single _y1;
        private Single _y2;
        /// <summary>
        /// Mode
        /// </summary>
        [DataMember()]
        public IRMode Mode
        {
            get
            {
                return this._mode;
            }
            set
            {
                this._mode = value;
            }
        }
        /// <summary>
        /// RawX1
        /// </summary>
        [DataMember()]
        public Int32 RawX1
        {
            get
            {
                return this._rawX1;
            }
            set
            {
                this._rawX1 = value;
            }
        }
        /// <summary>
        /// RawX2
        /// </summary>
        [DataMember()]
        public Int32 RawX2
        {
            get
            {
                return this._rawX2;
            }
            set
            {
                this._rawX2 = value;
            }
        }
        /// <summary>
        /// RawY1
        /// </summary>
        [DataMember()]
        public Int32 RawY1
        {
            get
            {
                return this._rawY1;
            }
            set
            {
                this._rawY1 = value;
            }
        }
        /// <summary>
        /// RawY2
        /// </summary>
        [DataMember()]
        public Int32 RawY2
        {
            get
            {
                return this._rawY2;
            }
            set
            {
                this._rawY2 = value;
            }
        }
        /// <summary>
        /// Size1
        /// </summary>
        [DataMember()]
        public Int32 Size1
        {
            get
            {
                return this._size1;
            }
            set
            {
                this._size1 = value;
            }
        }
        /// <summary>
        /// Size2
        /// </summary>
        [DataMember()]
        public Int32 Size2
        {
            get
            {
                return this._size2;
            }
            set
            {
                this._size2 = value;
            }
        }
        /// <summary>
        /// Found1
        /// </summary>
        [DataMember()]
        public Boolean Found1
        {
            get
            {
                return this._found1;
            }
            set
            {
                this._found1 = value;
            }
        }
        /// <summary>
        /// Found2
        /// </summary>
        [DataMember()]
        public Boolean Found2
        {
            get
            {
                return this._found2;
            }
            set
            {
                this._found2 = value;
            }
        }
        /// <summary>
        /// X1
        /// </summary>
        [DataMember()]
        public Single X1
        {
            get
            {
                return this._x1;
            }
            set
            {
                this._x1 = value;
            }
        }
        /// <summary>
        /// X2
        /// </summary>
        [DataMember()]
        public Single X2
        {
            get
            {
                return this._x2;
            }
            set
            {
                this._x2 = value;
            }
        }
        /// <summary>
        /// Y1
        /// </summary>
        [DataMember()]
        public Single Y1
        {
            get
            {
                return this._y1;
            }
            set
            {
                this._y1 = value;
            }
        }
        /// <summary>
        /// Y2
        /// </summary>
        [DataMember()]
        public Single Y2
        {
            get
            {
                return this._y2;
            }
            set
            {
                this._y2 = value;
            }
        }
        public void CopyTo(ref IRState target)
        {
            target.Mode = this.Mode;
            target.RawX1 = this.RawX1;
            target.RawX2 = this.RawX2;
            target.RawY1 = this.RawY1;
            target.RawY2 = this.RawY2;
            target.Size1 = this.Size1;
            target.Size2 = this.Size2;
            target.Found1 = this.Found1;
            target.Found2 = this.Found2;
            target.X1 = this.X1;
            target.X2 = this.X2;
            target.Y1 = this.Y1;
            target.Y2 = this.Y2;
        }
        public object Clone()
        {
            IRState target = new IRState();

            target.Mode = this.Mode;
            target.RawX1 = this.RawX1;
            target.RawX2 = this.RawX2;
            target.RawY1 = this.RawY1;
            target.RawY2 = this.RawY2;
            target.Size1 = this.Size1;
            target.Size2 = this.Size2;
            target.Found1 = this.Found1;
            target.Found2 = this.Found2;
            target.X1 = this.X1;
            target.X2 = this.X2;
            target.Y1 = this.Y1;
            target.Y2 = this.Y2;
            return target;

        }
    }
    /// <summary>
    /// IR Mode
    /// </summary>
    [DataContract()]
    [XmlRootAttribute("IRMode", Namespace="http://schemas.tempuri.org/2007/06/wiimote.html")]
    public enum IRMode
    {
        /// <summary>
        /// Off
        /// </summary>
        Off = 0,
        /// <summary>
        /// Basic
        /// </summary>
        Basic = 1,
        /// <summary>
        /// Extended
        /// </summary>
        Extended = 3,
        /// <summary>
        /// Full
        /// </summary>
        Full = 5,
    }
    /// <summary>
    /// Nunchuk State
    /// </summary>
    [DataContract()]
    [XmlRootAttribute("NunchukState", Namespace="http://schemas.tempuri.org/2007/06/wiimote.html")]
    public struct NunchukState : System.ICloneable
    {
        private NunchukCalibrationInfo _calibrationInfo;
        private AccelState _accelState;
        private Byte _rawX;
        private Byte _rawY;
        private Single _x;
        private Single _y;
        private Boolean _c;
        private Boolean _z;
        /// <summary>
        /// Calibration Info
        /// </summary>
        [DataMember()]
        public NunchukCalibrationInfo CalibrationInfo
        {
            get
            {
                return this._calibrationInfo;
            }
            set
            {
                this._calibrationInfo = value;
            }
        }
        /// <summary>
        /// Accel State
        /// </summary>
        [DataMember()]
        public AccelState AccelState
        {
            get
            {
                return this._accelState;
            }
            set
            {
                this._accelState = value;
            }
        }
        /// <summary>
        /// RawX
        /// </summary>
        [DataMember()]
        public Byte RawX
        {
            get
            {
                return this._rawX;
            }
            set
            {
                this._rawX = value;
            }
        }
        /// <summary>
        /// RawY
        /// </summary>
        [DataMember()]
        public Byte RawY
        {
            get
            {
                return this._rawY;
            }
            set
            {
                this._rawY = value;
            }
        }
        /// <summary>
        /// X
        /// </summary>
        [DataMember()]
        public Single X
        {
            get
            {
                return this._x;
            }
            set
            {
                this._x = value;
            }
        }
        /// <summary>
        /// Y
        /// </summary>
        [DataMember()]
        public Single Y
        {
            get
            {
                return this._y;
            }
            set
            {
                this._y = value;
            }
        }
        /// <summary>
        /// C
        /// </summary>
        [DataMember()]
        public Boolean C
        {
            get
            {
                return this._c;
            }
            set
            {
                this._c = value;
            }
        }
        /// <summary>
        /// Z
        /// </summary>
        [DataMember()]
        public Boolean Z
        {
            get
            {
                return this._z;
            }
            set
            {
                this._z = value;
            }
        }
        public void CopyTo(ref NunchukState target)
        {
            target.CalibrationInfo = this.CalibrationInfo;
            target.AccelState = this.AccelState;
            target.RawX = this.RawX;
            target.RawY = this.RawY;
            target.X = this.X;
            target.Y = this.Y;
            target.C = this.C;
            target.Z = this.Z;
        }
        public object Clone()
        {
            NunchukState target = new NunchukState();

            target.CalibrationInfo = this.CalibrationInfo;
            target.AccelState = this.AccelState;
            target.RawX = this.RawX;
            target.RawY = this.RawY;
            target.X = this.X;
            target.Y = this.Y;
            target.C = this.C;
            target.Z = this.Z;
            return target;

        }
    }
    /// <summary>
    /// Nunchuk Calibration Info
    /// </summary>
    [DataContract()]
    [XmlRootAttribute("NunchukCalibrationInfo", Namespace="http://schemas.tempuri.org/2007/06/wiimote.html")]
    public struct NunchukCalibrationInfo : System.ICloneable
    {
        private Byte _x0;
        private Byte _y0;
        private Byte _z0;
        private Byte _xG;
        private Byte _yG;
        private Byte _zG;
        private Byte _minX;
        private Byte _midX;
        private Byte _maxX;
        private Byte _minY;
        private Byte _midY;
        private Byte _maxY;
        /// <summary>
        /// X0
        /// </summary>
        [DataMember()]
        public Byte X0
        {
            get
            {
                return this._x0;
            }
            set
            {
                this._x0 = value;
            }
        }
        /// <summary>
        /// Y0
        /// </summary>
        [DataMember()]
        public Byte Y0
        {
            get
            {
                return this._y0;
            }
            set
            {
                this._y0 = value;
            }
        }
        /// <summary>
        /// Z0
        /// </summary>
        [DataMember()]
        public Byte Z0
        {
            get
            {
                return this._z0;
            }
            set
            {
                this._z0 = value;
            }
        }
        /// <summary>
        /// XG
        /// </summary>
        [DataMember()]
        public Byte XG
        {
            get
            {
                return this._xG;
            }
            set
            {
                this._xG = value;
            }
        }
        /// <summary>
        /// YG
        /// </summary>
        [DataMember()]
        public Byte YG
        {
            get
            {
                return this._yG;
            }
            set
            {
                this._yG = value;
            }
        }
        /// <summary>
        /// ZG
        /// </summary>
        [DataMember()]
        public Byte ZG
        {
            get
            {
                return this._zG;
            }
            set
            {
                this._zG = value;
            }
        }
        /// <summary>
        /// MinX
        /// </summary>
        [DataMember()]
        public Byte MinX
        {
            get
            {
                return this._minX;
            }
            set
            {
                this._minX = value;
            }
        }
        /// <summary>
        /// MidX
        /// </summary>
        [DataMember()]
        public Byte MidX
        {
            get
            {
                return this._midX;
            }
            set
            {
                this._midX = value;
            }
        }
        /// <summary>
        /// MaxX
        /// </summary>
        [DataMember()]
        public Byte MaxX
        {
            get
            {
                return this._maxX;
            }
            set
            {
                this._maxX = value;
            }
        }
        /// <summary>
        /// MinY
        /// </summary>
        [DataMember()]
        public Byte MinY
        {
            get
            {
                return this._minY;
            }
            set
            {
                this._minY = value;
            }
        }
        /// <summary>
        /// MidY
        /// </summary>
        [DataMember()]
        public Byte MidY
        {
            get
            {
                return this._midY;
            }
            set
            {
                this._midY = value;
            }
        }
        /// <summary>
        /// MaxY
        /// </summary>
        [DataMember()]
        public Byte MaxY
        {
            get
            {
                return this._maxY;
            }
            set
            {
                this._maxY = value;
            }
        }
        public void CopyTo(ref NunchukCalibrationInfo target)
        {
            target.X0 = this.X0;
            target.Y0 = this.Y0;
            target.Z0 = this.Z0;
            target.XG = this.XG;
            target.YG = this.YG;
            target.ZG = this.ZG;
            target.MinX = this.MinX;
            target.MidX = this.MidX;
            target.MaxX = this.MaxX;
            target.MinY = this.MinY;
            target.MidY = this.MidY;
            target.MaxY = this.MaxY;
        }
        public object Clone()
        {
            NunchukCalibrationInfo target = new NunchukCalibrationInfo();

            target.X0 = this.X0;
            target.Y0 = this.Y0;
            target.Z0 = this.Z0;
            target.XG = this.XG;
            target.YG = this.YG;
            target.ZG = this.ZG;
            target.MinX = this.MinX;
            target.MidX = this.MidX;
            target.MaxX = this.MaxX;
            target.MinY = this.MinY;
            target.MidY = this.MidY;
            target.MaxY = this.MaxY;
            return target;

        }
    }
    /// <summary>
    /// Classic Controller State
    /// </summary>
    [DataContract()]
    [XmlRootAttribute("ClassicControllerState", Namespace="http://schemas.tempuri.org/2007/06/wiimote.html")]
    public struct ClassicControllerState : System.ICloneable
    {
        private ClassicControllerCalibrationInfo _calibrationInfo;
        private ClassicControllerButtonState _buttonState;
        private Byte _rawXL;
        private Byte _rawYL;
        private Byte _rawXR;
        private Byte _rawYR;
        private Single _xL;
        private Single _yL;
        private Single _xR;
        private Single _yR;
        private Byte _rawTriggerL;
        private Byte _rawTriggerR;
        private Single _triggerL;
        private Single _triggerR;
        /// <summary>
        /// Calibration Info
        /// </summary>
        [DataMember()]
        public ClassicControllerCalibrationInfo CalibrationInfo
        {
            get
            {
                return this._calibrationInfo;
            }
            set
            {
                this._calibrationInfo = value;
            }
        }
        /// <summary>
        /// Button State
        /// </summary>
        [DataMember()]
        public ClassicControllerButtonState ButtonState
        {
            get
            {
                return this._buttonState;
            }
            set
            {
                this._buttonState = value;
            }
        }
        /// <summary>
        /// RawXL
        /// </summary>
        [DataMember()]
        public Byte RawXL
        {
            get
            {
                return this._rawXL;
            }
            set
            {
                this._rawXL = value;
            }
        }
        /// <summary>
        /// RawYL
        /// </summary>
        [DataMember()]
        public Byte RawYL
        {
            get
            {
                return this._rawYL;
            }
            set
            {
                this._rawYL = value;
            }
        }
        /// <summary>
        /// RawXR
        /// </summary>
        [DataMember()]
        public Byte RawXR
        {
            get
            {
                return this._rawXR;
            }
            set
            {
                this._rawXR = value;
            }
        }
        /// <summary>
        /// RawYR
        /// </summary>
        [DataMember()]
        public Byte RawYR
        {
            get
            {
                return this._rawYR;
            }
            set
            {
                this._rawYR = value;
            }
        }
        /// <summary>
        /// XL
        /// </summary>
        [DataMember()]
        public Single XL
        {
            get
            {
                return this._xL;
            }
            set
            {
                this._xL = value;
            }
        }
        /// <summary>
        /// YL
        /// </summary>
        [DataMember()]
        public Single YL
        {
            get
            {
                return this._yL;
            }
            set
            {
                this._yL = value;
            }
        }
        /// <summary>
        /// XR
        /// </summary>
        [DataMember()]
        public Single XR
        {
            get
            {
                return this._xR;
            }
            set
            {
                this._xR = value;
            }
        }
        /// <summary>
        /// YR
        /// </summary>
        [DataMember()]
        public Single YR
        {
            get
            {
                return this._yR;
            }
            set
            {
                this._yR = value;
            }
        }
        /// <summary>
        /// Raw TriggerL
        /// </summary>
        [DataMember()]
        public Byte RawTriggerL
        {
            get
            {
                return this._rawTriggerL;
            }
            set
            {
                this._rawTriggerL = value;
            }
        }
        /// <summary>
        /// Raw TriggerR
        /// </summary>
        [DataMember()]
        public Byte RawTriggerR
        {
            get
            {
                return this._rawTriggerR;
            }
            set
            {
                this._rawTriggerR = value;
            }
        }
        /// <summary>
        /// TriggerL
        /// </summary>
        [DataMember()]
        public Single TriggerL
        {
            get
            {
                return this._triggerL;
            }
            set
            {
                this._triggerL = value;
            }
        }
        /// <summary>
        /// TriggerR
        /// </summary>
        [DataMember()]
        public Single TriggerR
        {
            get
            {
                return this._triggerR;
            }
            set
            {
                this._triggerR = value;
            }
        }
        public void CopyTo(ref ClassicControllerState target)
        {
            target.CalibrationInfo = this.CalibrationInfo;
            target.ButtonState = this.ButtonState;
            target.RawXL = this.RawXL;
            target.RawYL = this.RawYL;
            target.RawXR = this.RawXR;
            target.RawYR = this.RawYR;
            target.XL = this.XL;
            target.YL = this.YL;
            target.XR = this.XR;
            target.YR = this.YR;
            target.RawTriggerL = this.RawTriggerL;
            target.RawTriggerR = this.RawTriggerR;
            target.TriggerL = this.TriggerL;
            target.TriggerR = this.TriggerR;
        }
        public object Clone()
        {
            ClassicControllerState target = new ClassicControllerState();

            target.CalibrationInfo = this.CalibrationInfo;
            target.ButtonState = this.ButtonState;
            target.RawXL = this.RawXL;
            target.RawYL = this.RawYL;
            target.RawXR = this.RawXR;
            target.RawYR = this.RawYR;
            target.XL = this.XL;
            target.YL = this.YL;
            target.XR = this.XR;
            target.YR = this.YR;
            target.RawTriggerL = this.RawTriggerL;
            target.RawTriggerR = this.RawTriggerR;
            target.TriggerL = this.TriggerL;
            target.TriggerR = this.TriggerR;
            return target;

        }
    }
    /// <summary>
    /// Classic Controller Calibration Info
    /// </summary>
    [DataContract()]
    [XmlRootAttribute("ClassicControllerCalibrationInfo", Namespace="http://schemas.tempuri.org/2007/06/wiimote.html")]
    public struct ClassicControllerCalibrationInfo : System.ICloneable
    {
        private Byte _minXL;
        private Byte _midXL;
        private Byte _maxXL;
        private Byte _minYL;
        private Byte _midYL;
        private Byte _maxYL;
        private Byte _minXR;
        private Byte _midXR;
        private Byte _maxXR;
        private Byte _minYR;
        private Byte _midYR;
        private Byte _maxYR;
        private Byte _minTriggerL;
        private Byte _maxTriggerL;
        private Byte _minTriggerR;
        private Byte _maxTriggerR;
        /// <summary>
        /// MinXL
        /// </summary>
        [DataMember()]
        public Byte MinXL
        {
            get
            {
                return this._minXL;
            }
            set
            {
                this._minXL = value;
            }
        }
        /// <summary>
        /// MidXL
        /// </summary>
        [DataMember()]
        public Byte MidXL
        {
            get
            {
                return this._midXL;
            }
            set
            {
                this._midXL = value;
            }
        }
        /// <summary>
        /// MaxXL
        /// </summary>
        [DataMember()]
        public Byte MaxXL
        {
            get
            {
                return this._maxXL;
            }
            set
            {
                this._maxXL = value;
            }
        }
        /// <summary>
        /// MinYL
        /// </summary>
        [DataMember()]
        public Byte MinYL
        {
            get
            {
                return this._minYL;
            }
            set
            {
                this._minYL = value;
            }
        }
        /// <summary>
        /// MidYL
        /// </summary>
        [DataMember()]
        public Byte MidYL
        {
            get
            {
                return this._midYL;
            }
            set
            {
                this._midYL = value;
            }
        }
        /// <summary>
        /// MaxYL
        /// </summary>
        [DataMember()]
        public Byte MaxYL
        {
            get
            {
                return this._maxYL;
            }
            set
            {
                this._maxYL = value;
            }
        }
        /// <summary>
        /// MinXR
        /// </summary>
        [DataMember()]
        public Byte MinXR
        {
            get
            {
                return this._minXR;
            }
            set
            {
                this._minXR = value;
            }
        }
        /// <summary>
        /// MidXR
        /// </summary>
        [DataMember()]
        public Byte MidXR
        {
            get
            {
                return this._midXR;
            }
            set
            {
                this._midXR = value;
            }
        }
        /// <summary>
        /// MaxXR
        /// </summary>
        [DataMember()]
        public Byte MaxXR
        {
            get
            {
                return this._maxXR;
            }
            set
            {
                this._maxXR = value;
            }
        }
        /// <summary>
        /// MinYR
        /// </summary>
        [DataMember()]
        public Byte MinYR
        {
            get
            {
                return this._minYR;
            }
            set
            {
                this._minYR = value;
            }
        }
        /// <summary>
        /// MidYR
        /// </summary>
        [DataMember()]
        public Byte MidYR
        {
            get
            {
                return this._midYR;
            }
            set
            {
                this._midYR = value;
            }
        }
        /// <summary>
        /// MaxYR
        /// </summary>
        [DataMember()]
        public Byte MaxYR
        {
            get
            {
                return this._maxYR;
            }
            set
            {
                this._maxYR = value;
            }
        }
        /// <summary>
        /// Min TriggerL
        /// </summary>
        [DataMember()]
        public Byte MinTriggerL
        {
            get
            {
                return this._minTriggerL;
            }
            set
            {
                this._minTriggerL = value;
            }
        }
        /// <summary>
        /// Max TriggerL
        /// </summary>
        [DataMember()]
        public Byte MaxTriggerL
        {
            get
            {
                return this._maxTriggerL;
            }
            set
            {
                this._maxTriggerL = value;
            }
        }
        /// <summary>
        /// Min TriggerR
        /// </summary>
        [DataMember()]
        public Byte MinTriggerR
        {
            get
            {
                return this._minTriggerR;
            }
            set
            {
                this._minTriggerR = value;
            }
        }
        /// <summary>
        /// Max TriggerR
        /// </summary>
        [DataMember()]
        public Byte MaxTriggerR
        {
            get
            {
                return this._maxTriggerR;
            }
            set
            {
                this._maxTriggerR = value;
            }
        }
        public void CopyTo(ref ClassicControllerCalibrationInfo target)
        {
            target.MinXL = this.MinXL;
            target.MidXL = this.MidXL;
            target.MaxXL = this.MaxXL;
            target.MinYL = this.MinYL;
            target.MidYL = this.MidYL;
            target.MaxYL = this.MaxYL;
            target.MinXR = this.MinXR;
            target.MidXR = this.MidXR;
            target.MaxXR = this.MaxXR;
            target.MinYR = this.MinYR;
            target.MidYR = this.MidYR;
            target.MaxYR = this.MaxYR;
            target.MinTriggerL = this.MinTriggerL;
            target.MaxTriggerL = this.MaxTriggerL;
            target.MinTriggerR = this.MinTriggerR;
            target.MaxTriggerR = this.MaxTriggerR;
        }
        public object Clone()
        {
            ClassicControllerCalibrationInfo target = new ClassicControllerCalibrationInfo();

            target.MinXL = this.MinXL;
            target.MidXL = this.MidXL;
            target.MaxXL = this.MaxXL;
            target.MinYL = this.MinYL;
            target.MidYL = this.MidYL;
            target.MaxYL = this.MaxYL;
            target.MinXR = this.MinXR;
            target.MidXR = this.MidXR;
            target.MaxXR = this.MaxXR;
            target.MinYR = this.MinYR;
            target.MidYR = this.MidYR;
            target.MaxYR = this.MaxYR;
            target.MinTriggerL = this.MinTriggerL;
            target.MaxTriggerL = this.MaxTriggerL;
            target.MinTriggerR = this.MinTriggerR;
            target.MaxTriggerR = this.MaxTriggerR;
            return target;

        }
    }
    /// <summary>
    /// Classic Controller Button State
    /// </summary>
    [DataContract()]
    [XmlRootAttribute("ClassicControllerButtonState", Namespace="http://schemas.tempuri.org/2007/06/wiimote.html")]
    public struct ClassicControllerButtonState : System.ICloneable
    {
        private Boolean _a;
        private Boolean _b;
        private Boolean _plus;
        private Boolean _home;
        private Boolean _minus;
        private Boolean _up;
        private Boolean _down;
        private Boolean _left;
        private Boolean _right;
        private Boolean _x;
        private Boolean _y;
        private Boolean _zL;
        private Boolean _zR;
        private Boolean _triggerL;
        private Boolean _triggerR;
        /// <summary>
        /// A
        /// </summary>
        [DataMember()]
        public Boolean A
        {
            get
            {
                return this._a;
            }
            set
            {
                this._a = value;
            }
        }
        /// <summary>
        /// B
        /// </summary>
        [DataMember()]
        public Boolean B
        {
            get
            {
                return this._b;
            }
            set
            {
                this._b = value;
            }
        }
        /// <summary>
        /// Plus
        /// </summary>
        [DataMember()]
        public Boolean Plus
        {
            get
            {
                return this._plus;
            }
            set
            {
                this._plus = value;
            }
        }
        /// <summary>
        /// Home
        /// </summary>
        [DataMember()]
        public Boolean Home
        {
            get
            {
                return this._home;
            }
            set
            {
                this._home = value;
            }
        }
        /// <summary>
        /// Minus
        /// </summary>
        [DataMember()]
        public Boolean Minus
        {
            get
            {
                return this._minus;
            }
            set
            {
                this._minus = value;
            }
        }
        /// <summary>
        /// Up
        /// </summary>
        [DataMember()]
        public Boolean Up
        {
            get
            {
                return this._up;
            }
            set
            {
                this._up = value;
            }
        }
        /// <summary>
        /// Down
        /// </summary>
        [DataMember()]
        public Boolean Down
        {
            get
            {
                return this._down;
            }
            set
            {
                this._down = value;
            }
        }
        /// <summary>
        /// Left
        /// </summary>
        [DataMember()]
        public Boolean Left
        {
            get
            {
                return this._left;
            }
            set
            {
                this._left = value;
            }
        }
        /// <summary>
        /// Right
        /// </summary>
        [DataMember()]
        public Boolean Right
        {
            get
            {
                return this._right;
            }
            set
            {
                this._right = value;
            }
        }
        /// <summary>
        /// X
        /// </summary>
        [DataMember()]
        public Boolean X
        {
            get
            {
                return this._x;
            }
            set
            {
                this._x = value;
            }
        }
        /// <summary>
        /// Y
        /// </summary>
        [DataMember()]
        public Boolean Y
        {
            get
            {
                return this._y;
            }
            set
            {
                this._y = value;
            }
        }
        /// <summary>
        /// ZL
        /// </summary>
        [DataMember()]
        public Boolean ZL
        {
            get
            {
                return this._zL;
            }
            set
            {
                this._zL = value;
            }
        }
        /// <summary>
        /// ZR
        /// </summary>
        [DataMember()]
        public Boolean ZR
        {
            get
            {
                return this._zR;
            }
            set
            {
                this._zR = value;
            }
        }
        /// <summary>
        /// TriggerL
        /// </summary>
        [DataMember()]
        public Boolean TriggerL
        {
            get
            {
                return this._triggerL;
            }
            set
            {
                this._triggerL = value;
            }
        }
        /// <summary>
        /// TriggerR
        /// </summary>
        [DataMember()]
        public Boolean TriggerR
        {
            get
            {
                return this._triggerR;
            }
            set
            {
                this._triggerR = value;
            }
        }
        public void CopyTo(ref ClassicControllerButtonState target)
        {
            target.A = this.A;
            target.B = this.B;
            target.Plus = this.Plus;
            target.Home = this.Home;
            target.Minus = this.Minus;
            target.Up = this.Up;
            target.Down = this.Down;
            target.Left = this.Left;
            target.Right = this.Right;
            target.X = this.X;
            target.Y = this.Y;
            target.ZL = this.ZL;
            target.ZR = this.ZR;
            target.TriggerL = this.TriggerL;
            target.TriggerR = this.TriggerR;
        }
        public object Clone()
        {
            ClassicControllerButtonState target = new ClassicControllerButtonState();

            target.A = this.A;
            target.B = this.B;
            target.Plus = this.Plus;
            target.Home = this.Home;
            target.Minus = this.Minus;
            target.Up = this.Up;
            target.Down = this.Down;
            target.Left = this.Left;
            target.Right = this.Right;
            target.X = this.X;
            target.Y = this.Y;
            target.ZL = this.ZL;
            target.ZR = this.ZR;
            target.TriggerL = this.TriggerL;
            target.TriggerR = this.TriggerR;
            return target;

        }
    }
    /// <summary>
    /// Wiimote Operations
    /// </summary>
    [XmlTypeAttribute(IncludeInSchema=false)]
    public class WiimoteOperations : PortSet<Microsoft.Dss.ServiceModel.Dssp.DsspDefaultLookup, Microsoft.Dss.ServiceModel.Dssp.DsspDefaultDrop, Get, Subscribe, WiimoteChanged, SetLEDs, SetRumble>
    {
        // Post DsspDefaultLookup and return the response port.
        public virtual PortSet<Microsoft.Dss.ServiceModel.Dssp.LookupResponse,Fault> DsspDefaultLookup(Microsoft.Dss.ServiceModel.Dssp.LookupRequestType body)
        {
            Microsoft.Dss.ServiceModel.Dssp.DsspDefaultLookup op = new Microsoft.Dss.ServiceModel.Dssp.DsspDefaultLookup();
            op.Body = body ?? new Microsoft.Dss.ServiceModel.Dssp.LookupRequestType();
            this.Post(op);
            return op.ResponsePort;

        }
        // Post DsspDefaultLookup and return the response port.
        public virtual PortSet<Microsoft.Dss.ServiceModel.Dssp.LookupResponse,Fault> DsspDefaultLookup()
        {
            Microsoft.Dss.ServiceModel.Dssp.DsspDefaultLookup op = new Microsoft.Dss.ServiceModel.Dssp.DsspDefaultLookup();
            op.Body = new Microsoft.Dss.ServiceModel.Dssp.LookupRequestType();
            this.Post(op);
            return op.ResponsePort;

        }
        // Post DsspDefaultDrop and return the response port.
        public virtual PortSet<Microsoft.Dss.ServiceModel.Dssp.DefaultDropResponseType,Fault> DsspDefaultDrop(Microsoft.Dss.ServiceModel.Dssp.DropRequestType body)
        {
            Microsoft.Dss.ServiceModel.Dssp.DsspDefaultDrop op = new Microsoft.Dss.ServiceModel.Dssp.DsspDefaultDrop();
            op.Body = body ?? new Microsoft.Dss.ServiceModel.Dssp.DropRequestType();
            this.Post(op);
            return op.ResponsePort;

        }
        // Post DsspDefaultDrop and return the response port.
        public virtual PortSet<Microsoft.Dss.ServiceModel.Dssp.DefaultDropResponseType,Fault> DsspDefaultDrop()
        {
            Microsoft.Dss.ServiceModel.Dssp.DsspDefaultDrop op = new Microsoft.Dss.ServiceModel.Dssp.DsspDefaultDrop();
            op.Body = new Microsoft.Dss.ServiceModel.Dssp.DropRequestType();
            this.Post(op);
            return op.ResponsePort;

        }
        // Post Get and return the response port.
        public virtual PortSet<WiimoteState,Fault> Get(Microsoft.Dss.ServiceModel.Dssp.GetRequestType body)
        {
            Get op = new Get();
            op.Body = body ?? new Microsoft.Dss.ServiceModel.Dssp.GetRequestType();
            this.Post(op);
            return op.ResponsePort;

        }
        // Post Get and return the response port.
        public virtual PortSet<WiimoteState,Fault> Get()
        {
            Get op = new Get();
            op.Body = new Microsoft.Dss.ServiceModel.Dssp.GetRequestType();
            this.Post(op);
            return op.ResponsePort;

        }
        // Post Subscribe and return the response port.
        public virtual PortSet<Microsoft.Dss.ServiceModel.Dssp.SubscribeResponseType,Fault> Subscribe(Microsoft.Dss.ServiceModel.Dssp.SubscribeRequestType body, IPort notificationPort)
        {
            Subscribe op = new Subscribe();
            op.Body = body ?? new Microsoft.Dss.ServiceModel.Dssp.SubscribeRequestType();
            op.NotificationPort = notificationPort;
            this.Post(op);
            return op.ResponsePort;

        }
        // Post Subscribe and return the response port.
        public virtual PortSet<Microsoft.Dss.ServiceModel.Dssp.SubscribeResponseType,Fault> Subscribe(IPort notificationPort)
        {
            Subscribe op = new Subscribe();
            op.Body = new Microsoft.Dss.ServiceModel.Dssp.SubscribeRequestType();
            op.NotificationPort = notificationPort;
            this.Post(op);
            return op.ResponsePort;

        }
        // Post WiimoteChanged and return the response port.
        public virtual Microsoft.Dss.ServiceModel.Dssp.DsspResponsePort<Microsoft.Dss.ServiceModel.Dssp.DefaultUpdateResponseType> WiimoteChanged(WiimoteState body)
        {
            WiimoteChanged op = new WiimoteChanged();
            op.Body = body ?? new WiimoteState();
            this.Post(op);
            return op.ResponsePort;

        }
        // Post SetLEDs and return the response port.
        public virtual Microsoft.Dss.ServiceModel.Dssp.DsspResponsePort<Microsoft.Dss.ServiceModel.Dssp.DefaultUpdateResponseType> SetLEDs(LEDs body)
        {
            SetLEDs op = new SetLEDs();
            op.Body = body;
            this.Post(op);
            return op.ResponsePort;

        }
        // Post SetRumble and return the response port.
        public virtual Microsoft.Dss.ServiceModel.Dssp.DsspResponsePort<Microsoft.Dss.ServiceModel.Dssp.DefaultUpdateResponseType> SetRumble(RumbleRequest body)
        {
            SetRumble op = new SetRumble();
            op.Body = body;
            this.Post(op);
            return op.ResponsePort;

        }
    }
    /// <summary>
    /// Get
    /// </summary>
    [XmlTypeAttribute(IncludeInSchema=false)]
    public class Get : Microsoft.Dss.ServiceModel.Dssp.Get<Microsoft.Dss.ServiceModel.Dssp.GetRequestType, PortSet<WiimoteState, Fault>>
    {
        public Get()
        {
        }
        public Get(Microsoft.Dss.ServiceModel.Dssp.GetRequestType body) : 
                base(body)
        {
        }
        public Get(Microsoft.Dss.ServiceModel.Dssp.GetRequestType body, Microsoft.Ccr.Core.PortSet<WiimoteState,W3C.Soap.Fault> responsePort) : 
                base(body, responsePort)
        {
        }
    }
    /// <summary>
    /// Subscribe to Wiimote service notifications.
    /// </summary>
    [XmlTypeAttribute(IncludeInSchema=false)]
    [DisplayName("Subscribe")]
    [Description("Subscribe to Wiimote service notifications.")]
    public class Subscribe : Microsoft.Dss.ServiceModel.Dssp.Subscribe<Microsoft.Dss.ServiceModel.Dssp.SubscribeRequestType, PortSet<Microsoft.Dss.ServiceModel.Dssp.SubscribeResponseType, Fault>>
    {
        public Subscribe()
        {
        }
        public Subscribe(Microsoft.Dss.ServiceModel.Dssp.SubscribeRequestType body) : 
                base(body)
        {
        }
        public Subscribe(Microsoft.Dss.ServiceModel.Dssp.SubscribeRequestType body, Microsoft.Ccr.Core.PortSet<Microsoft.Dss.ServiceModel.Dssp.SubscribeResponseType,W3C.Soap.Fault> responsePort) : 
                base(body, responsePort)
        {
        }
    }
    /// <summary>
    /// Wiimote Changed
    /// </summary>
    [XmlTypeAttribute(IncludeInSchema=false)]
    public class WiimoteChanged : Microsoft.Dss.ServiceModel.Dssp.Update<WiimoteState, Microsoft.Dss.ServiceModel.Dssp.DsspResponsePort<Microsoft.Dss.ServiceModel.Dssp.DefaultUpdateResponseType>>
    {
        public WiimoteChanged()
        {
        }
        public WiimoteChanged(WiimoteState body) : 
                base(body)
        {
        }
        public WiimoteChanged(WiimoteState body, Microsoft.Dss.ServiceModel.Dssp.DsspResponsePort<Microsoft.Dss.ServiceModel.Dssp.DefaultUpdateResponseType> responsePort) : 
                base(body, responsePort)
        {
        }
    }
    /// <summary>
    /// Set Wiimote Leds
    /// </summary>
    [XmlTypeAttribute(IncludeInSchema=false)]
    [DisplayName("Set Wiimote Leds")]
    public class SetLEDs : Microsoft.Dss.ServiceModel.Dssp.Update<LEDs, Microsoft.Dss.ServiceModel.Dssp.DsspResponsePort<Microsoft.Dss.ServiceModel.Dssp.DefaultUpdateResponseType>>
    {
        public SetLEDs()
        {
        }
        public SetLEDs(LEDs body) : 
                base(body)
        {
        }
        public SetLEDs(LEDs body, Microsoft.Dss.ServiceModel.Dssp.DsspResponsePort<Microsoft.Dss.ServiceModel.Dssp.DefaultUpdateResponseType> responsePort) : 
                base(body, responsePort)
        {
        }
    }
    /// <summary>
    /// Set Wiimote Rumble
    /// </summary>
    [XmlTypeAttribute(IncludeInSchema=false)]
    [DisplayName("Set Wiimote Rumble")]
    public class SetRumble : Microsoft.Dss.ServiceModel.Dssp.Update<RumbleRequest, Microsoft.Dss.ServiceModel.Dssp.DsspResponsePort<Microsoft.Dss.ServiceModel.Dssp.DefaultUpdateResponseType>>
    {
        public SetRumble()
        {
        }
        public SetRumble(RumbleRequest body) : 
                base(body)
        {
        }
        public SetRumble(RumbleRequest body, Microsoft.Dss.ServiceModel.Dssp.DsspResponsePort<Microsoft.Dss.ServiceModel.Dssp.DefaultUpdateResponseType> responsePort) : 
                base(body, responsePort)
        {
        }
    }
}
