//------------------------------------------------------------------------------
// Wiimote.cs
//
//     This code was generated by the DssNewService tool.
//
//------------------------------------------------------------------------------
using Microsoft.Ccr.Core;
using Microsoft.Dss.Core;
using Microsoft.Dss.Core.Attributes;
using Microsoft.Dss.ServiceModel.Dssp;
using Microsoft.Dss.ServiceModel.DsspServiceBase;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Xml;
using wiimotelib = WiimoteLib;
using submgr = Microsoft.Dss.Services.SubscriptionManager;
using dflt = Microsoft.Dss.Services.DefaultTarget;

namespace WiimoteLib
{
    
    /// <summary>
    /// The Wiimote Service
    /// </summary>
    [DisplayName("Wiimote")]
    [Description("The Wiimote Service")]
    [Contract(Contract.Identifier)]
    public class WiimoteService : DsspServiceBase
    {
        /// <summary>
        /// _state
        /// </summary>
        private WiimoteState _state = new WiimoteState();
        /// <summary>
        /// _main Port
        /// </summary>
        [ServicePort("/wiimote", AllowMultipleInstances=false)]
        private WiimoteOperations _mainPort = new WiimoteOperations();

		// internal port to post changes from the wiimote library's event
        private Port<WiimoteChanged> _internalStateChangedPort = new Port<WiimoteChanged>();

		// instance of the wiimote library
        private Wiimote _wm = new Wiimote();

        // Subscription manager partner
        [Partner(Partners.SubscriptionManagerString,
            Contract = submgr.Contract.Identifier,
            CreationPolicy = PartnerCreationPolicy.CreateAlways)]
        submgr.SubscriptionManagerPort _subMgrPort = new submgr.SubscriptionManagerPort();

        /// <summary>
        /// Default Service Constructor
        /// </summary>
        public WiimoteService(DsspServiceCreationPort creationPort) : 
                base(creationPort)
        {
        }
        /// <summary>
        /// Service Start
        /// </summary>
        protected override void Start()
        {
			base.Start();

			// setup internal notifications when we receive a OnWiimoteChanged event
			Activate(Arbiter.Receive(true, _internalStateChangedPort, InternalWiimoteChangedHandler));

			// hookup event handlers
            _wm.OnWiimoteChanged += new WiimoteChangedEventHandler(wm_OnWiimoteChanged);
            _wm.OnWiimoteExtensionChanged += new WiimoteExtensionChanged(wm_OnWiimoteExtensionChanged);

			// connect to wiimote and setup standard params
            _wm.Connect();
            _wm.SetReportType(Wiimote.InputReport.IRAccel, true);
            _wm.SetLEDs(false, true, false, true);
        }

        void wm_OnWiimoteChanged(object sender, WiimoteChangedEventArgs args)
        {
			// when we get an update from the lib, post a msg to our internal update port
            _internalStateChangedPort.Post(new WiimoteChanged(args.WiimoteState));
        }

        void wm_OnWiimoteExtensionChanged(object sender, WiimoteExtensionChangedEventArgs args)
        {
			// when an extension is plugged in, change the report type (not that any of them are actually
			// working right now with this service
            if (args.Inserted)
                _wm.SetReportType(Wiimote.InputReport.IRExtensionAccel, true);
            else
                _wm.SetReportType(Wiimote.InputReport.IRAccel, true);
        }

        public void InternalWiimoteChangedHandler(WiimoteChanged update)
        {
            _state = update.Body;

			// send a msg to our subscribers that the wiimote changed
            SendNotification<WiimoteChanged>(_subMgrPort, update);

            update.ResponsePort.Post(DefaultUpdateResponseType.Instance);
        }

        [ServiceHandler(ServiceHandlerBehavior.Exclusive)]
        public void SetLEDsHandler(SetLEDs update)
        {
			// handle setting LEDs from the outside world
            _wm.SetLEDs(update.Body.LED1, update.Body.LED2, update.Body.LED3, update.Body.LED4);
            _state.LEDs = update.Body;
            update.ResponsePort.Post(DefaultUpdateResponseType.Instance);
        }

        [ServiceHandler(ServiceHandlerBehavior.Exclusive)]
        public void SetRumbleHandler(SetRumble update)
        {
			// handle setting rumble state from outside world
            _state.Rumble = update.Body.Rumble;
            _wm.SetRumble(update.Body.Rumble);
            update.ResponsePort.Post(DefaultUpdateResponseType.Instance);
        }

        [ServiceHandler(ServiceHandlerBehavior.Exclusive)]
        public virtual IEnumerator<ITask> SubscribeHandler(Subscribe subscribe)
        {
			// handle subscriptions from other services
            yield return Arbiter.Choice(
                base.SubscribeHelper(_subMgrPort, subscribe.Body, subscribe.ResponsePort),
                delegate(SuccessResult success)
                {
                    SendNotification<WiimoteChanged>(_subMgrPort, subscribe.Body.Subscriber, new WiimoteChanged(_state));
                },
                delegate(Exception fault)
                {
                    LogError(fault);
                }
            );

            yield break;
        }

        [ServiceHandler(ServiceHandlerBehavior.Teardown)]
        public virtual IEnumerator<ITask> DropHandler(dflt.Drop drop)
        {
			// drop the connection to the Wiimote
            _wm.Disconnect();
            yield break;
        }

        /// <summary>
        /// Get Handler
        /// </summary>
        /// <param name="get"></param>
        /// <returns></returns>
        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public virtual IEnumerator<ITask> GetHandler(Get get)
        {
            get.ResponsePort.Post(_state);
            yield break;
        }
    }
}
